/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.protocol;

import com.icbc.api.internal.apache.http.HttpConnection;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpInetConnection;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestInterceptor;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpCoreContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull((Object)httpRequest, (String)"HTTP request");
        HttpCoreContext httpCoreContext = HttpCoreContext.adapt(httpContext);
        ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT") && protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!httpRequest.containsHeader("Host")) {
            HttpHost httpHost = httpCoreContext.getTargetHost();
            if (httpHost == null) {
                HttpConnection httpConnection = httpCoreContext.getConnection();
                if (httpConnection instanceof HttpInetConnection) {
                    InetAddress inetAddress = ((HttpInetConnection)httpConnection).getRemoteAddress();
                    int n = ((HttpInetConnection)httpConnection).getRemotePort();
                    if (inetAddress != null) {
                        httpHost = new HttpHost(inetAddress.getHostName(), n);
                    }
                }
                if (httpHost == null) {
                    if (protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            httpRequest.addHeader("Host", httpHost.toHostString());
        }
    }
}

