/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.protocol;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.protocol.HttpRequestHandler;
import com.icbc.api.internal.apache.http.protocol.HttpRequestHandlerMapper;
import com.icbc.api.internal.apache.http.protocol.UriPatternMatcher;
import com.icbc.api.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriHttpRequestHandlerMapper
implements HttpRequestHandlerMapper {
    private final UriPatternMatcher<HttpRequestHandler> matcher;

    protected UriHttpRequestHandlerMapper(UriPatternMatcher<HttpRequestHandler> uriPatternMatcher) {
        this.matcher = (UriPatternMatcher)Args.notNull(uriPatternMatcher, (String)"Pattern matcher");
    }

    public UriHttpRequestHandlerMapper() {
        this(new UriPatternMatcher<HttpRequestHandler>());
    }

    public void register(String string, HttpRequestHandler httpRequestHandler) {
        Args.notNull((Object)string, (String)"Pattern");
        Args.notNull((Object)httpRequestHandler, (String)"Handler");
        this.matcher.register(string, httpRequestHandler);
    }

    public void unregister(String string) {
        this.matcher.unregister(string);
    }

    protected String getRequestPath(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getUri();
        int n = string.indexOf("?");
        if (n != -1) {
            string = string.substring(0, n);
        } else {
            n = string.indexOf("#");
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    @Override
    public HttpRequestHandler lookup(HttpRequest httpRequest) {
        Args.notNull((Object)httpRequest, (String)"HTTP request");
        return this.matcher.lookup(this.getRequestPath(httpRequest));
    }
}

