/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.util;

import com.icbc.api.internal.apache.http.Consts;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.UnsupportedEncodingException;

public final class EncodingUtils {
    public static String getString(byte[] byArray, int n, int n2, String string) {
        Args.notNull((Object)byArray, (String)"Input");
        Args.notEmpty((CharSequence)string, (String)"Charset");
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    public static String getString(byte[] byArray, String string) {
        Args.notNull((Object)byArray, (String)"Input");
        return EncodingUtils.getString(byArray, 0, byArray.length, string);
    }

    public static byte[] getBytes(String string, String string2) {
        Args.notNull((Object)string, (String)"Input");
        Args.notEmpty((CharSequence)string2, (String)"Charset");
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String string) {
        Args.notNull((Object)string, (String)"Input");
        return string.getBytes(Consts.ASCII);
    }

    public static String getAsciiString(byte[] byArray, int n, int n2) {
        Args.notNull((Object)byArray, (String)"Input");
        return new String(byArray, n, n2, Consts.ASCII);
    }

    public static String getAsciiString(byte[] byArray) {
        Args.notNull((Object)byArray, (String)"Input");
        return EncodingUtils.getAsciiString(byArray, 0, byArray.length);
    }

    private EncodingUtils() {
    }
}

