/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.util;

import com.icbc.api.internal.apache.http.HeaderElement;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.NameValuePair;
import com.icbc.api.internal.apache.http.ParseException;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.protocol.HTTP;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.ByteArrayBuffer;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity httpEntity) {
        try {
            EntityUtils.consume(httpEntity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(HttpEntity httpEntity) throws IOException {
        InputStream inputStream;
        if (httpEntity == null) {
            return;
        }
        if (httpEntity.isStreaming() && (inputStream = httpEntity.getContent()) != null) {
            inputStream.close();
        }
    }

    public static void updateEntity(HttpResponse httpResponse, HttpEntity httpEntity) throws IOException {
        Args.notNull((Object)httpResponse, (String)"Response");
        EntityUtils.consume(httpResponse.getEntity());
        httpResponse.setEntity(httpEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(HttpEntity httpEntity) throws IOException {
        Args.notNull((Object)httpEntity, (String)"Entity");
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            Args.check((httpEntity.getContentLength() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"HTTP entity too large to be buffered in memory");
            int n2 = (int)httpEntity.getContentLength();
            if (n2 < 0) {
                n2 = 4096;
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n2);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayBuffer.append(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayBuffer.toByteArray();
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    @Deprecated
    public static String getContentCharSet(HttpEntity httpEntity) throws ParseException {
        NameValuePair nameValuePair;
        HeaderElement[] headerElementArray;
        Args.notNull((Object)httpEntity, (String)"Entity");
        String string = null;
        if (httpEntity.getContentType() != null && (headerElementArray = httpEntity.getContentType().getElements()).length > 0 && (nameValuePair = headerElementArray[0].getParameterByName("charset")) != null) {
            string = nameValuePair.getValue();
        }
        return string;
    }

    @Deprecated
    public static String getContentMimeType(HttpEntity httpEntity) throws ParseException {
        HeaderElement[] headerElementArray;
        Args.notNull((Object)httpEntity, (String)"Entity");
        String string = null;
        if (httpEntity.getContentType() != null && (headerElementArray = httpEntity.getContentType().getElements()).length > 0) {
            string = headerElementArray[0].getName();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(HttpEntity httpEntity, Charset charset) throws IOException, ParseException {
        Args.notNull((Object)httpEntity, (String)"Entity");
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            Object object;
            Charset charset2;
            int n2;
            block11: {
                Args.check((httpEntity.getContentLength() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"HTTP entity too large to be buffered in memory");
                n2 = (int)httpEntity.getContentLength();
                if (n2 < 0) {
                    n2 = 4096;
                }
                charset2 = null;
                try {
                    object = ContentType.get(httpEntity);
                    if (object != null) {
                        charset2 = ((ContentType)object).getCharset();
                    }
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    if (charset != null) break block11;
                    throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
                }
            }
            if (charset2 == null) {
                charset2 = charset;
            }
            if (charset2 == null) {
                charset2 = HTTP.DEF_CONTENT_CHARSET;
            }
            object = new InputStreamReader(inputStream, charset2);
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer(n2);
            char[] cArray = new char[1024];
            while ((n = ((Reader)object).read(cArray)) != -1) {
                charArrayBuffer.append(cArray, 0, n);
            }
            String string = charArrayBuffer.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static String toString(HttpEntity httpEntity, String string) throws IOException, ParseException {
        return EntityUtils.toString(httpEntity, string != null ? Charset.forName(string) : null);
    }

    public static String toString(HttpEntity httpEntity) throws IOException, ParseException {
        return EntityUtils.toString(httpEntity, (Charset)null);
    }
}

