/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.utils;

import com.icbc.api.IcbcApiException;
import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.ParseException;
import com.icbc.api.internal.apache.http.client.ClientProtocolException;
import com.icbc.api.internal.apache.http.client.entity.UrlEncodedFormEntity;
import com.icbc.api.internal.apache.http.client.methods.HttpGet;
import com.icbc.api.internal.apache.http.client.methods.HttpPost;
import com.icbc.api.internal.apache.http.client.methods.HttpRequestBase;
import com.icbc.api.internal.apache.http.client.methods.HttpUriRequest;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.entity.StringEntity;
import com.icbc.api.internal.apache.http.message.BasicNameValuePair;
import com.icbc.api.internal.apache.http.util.EntityUtils;
import com.icbc.api.internal.util.StringUtils;
import com.icbc.api.utils.HttpClientUtils;
import com.icbc.api.utils.IcbcHashMap;
import com.icbc.api.utils.WebUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebUtils {
    private static final Log logger = LogFactory.getLog(WebUtils.class);
    private static String CHARSET_UTF8 = "UTF-8";
    private static Pattern CHARSET_PATTERN = Pattern.compile(".*charset=(.+)");
    private static String version = "v2_20190522";

    public static void doPost(String string, Map<String, String> map, String string2, IcbcApiFutureCallback<String> icbcApiFutureCallback) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        WebUtils.doPost(string, map, (Map<String, String>)icbcHashMap, string2, icbcApiFutureCallback);
    }

    public static void doGet(String string, Map<String, String> map, String string2, IcbcApiFutureCallback<String> icbcApiFutureCallback) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        WebUtils.doGet(string, map, (Map<String, String>)icbcHashMap, string2, icbcApiFutureCallback);
    }

    public static void doPost(String string, Map<String, String> map, Map<String, String> map2, String string2, IcbcApiFutureCallback<String> icbcApiFutureCallback) throws IcbcApiException {
        WebUtils.doPost(string, WebUtils.buildPostHttpEntity(map, string2), map2, string2, icbcApiFutureCallback);
    }

    public static void doPost(String string, HttpEntity httpEntity, Map<String, String> map, String string2, IcbcApiFutureCallback<String> icbcApiFutureCallback) throws IcbcApiException {
        HttpPost httpPost = new HttpPost(string);
        httpPost.setEntity(httpEntity);
        if (map != null) {
            WebUtils.addHeaders(httpPost, map);
        }
        WebUtils.execute(httpPost, icbcApiFutureCallback);
    }

    public static void doGet(String string, Map<String, String> map, Map<String, String> map2, String string2, IcbcApiFutureCallback<String> icbcApiFutureCallback) throws IcbcApiException {
        String string3 = WebUtils.buildGetUrl(string, map, string2);
        HttpGet httpGet = new HttpGet(string3);
        if (map2 != null) {
            WebUtils.addHeaders(httpGet, map2);
        }
        WebUtils.execute(httpGet, icbcApiFutureCallback);
    }

    public static void execute(final HttpRequestBase httpRequestBase, final IcbcApiFutureCallback<String> icbcApiFutureCallback) throws IcbcApiException {
        HttpClientUtils.getAsyncHttpClient().execute(httpRequestBase, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(HttpResponse httpResponse) {
                int n = httpResponse.getStatusLine().getStatusCode();
                try {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    try {
                        String string = EntityUtils.toString(httpEntity, WebUtils.getResponseEncoding(httpEntity));
                        if (n != 200) {
                            throw new IcbcApiException("response status code is not valid. status code: " + n + " resp is:" + string);
                        }
                        icbcApiFutureCallback.completed((Object)string);
                    }
                    catch (ParseException parseException) {
                        throw new IcbcApiException("parse respose exception.", (Throwable)parseException);
                    }
                    catch (IOException iOException) {
                        throw new IcbcApiException("io exception.", (Throwable)iOException);
                    }
                }
                catch (IcbcApiException icbcApiException) {
                    icbcApiFutureCallback.failed(icbcApiException);
                }
                finally {
                    com.icbc.api.internal.apache.http.client.utils.HttpClientUtils.closeQuietly(httpResponse);
                }
            }

            @Override
            public void failed(Exception exception) {
                try {
                    icbcApiFutureCallback.failed(new IcbcApiException("async http client execute failed.", (Throwable)exception));
                }
                finally {
                    httpRequestBase.releaseConnection();
                }
            }

            @Override
            public void cancelled() {
                try {
                    icbcApiFutureCallback.failed(new IcbcApiException("async http client execute has been cancelled."));
                }
                finally {
                    httpRequestBase.releaseConnection();
                }
            }
        });
    }

    public static String doPost(String string, Map<String, String> map, String string2) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        icbcHashMap.put("Request-Type", "3");
        return WebUtils.doPost(string, map, (Map<String, String>)icbcHashMap, string2);
    }

    public static String doGet(String string, Map<String, String> map, String string2) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        return WebUtils.doGet(string, map, (Map<String, String>)icbcHashMap, string2);
    }

    public static String doPost(String string, Map<String, String> map, String string2, Map<String, String> map2) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        Set<Map.Entry<String, String>> set = map2.entrySet();
        for (Map.Entry<String, String> entry : set) {
            try {
                icbcHashMap.put(entry.getKey(), URLEncoder.encode(entry.getValue(), string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IcbcApiException((Throwable)unsupportedEncodingException);
            }
        }
        return WebUtils.doPost(string, map, (Map<String, String>)icbcHashMap, string2);
    }

    public static String doGet(String string, Map<String, String> map, String string2, Map<String, String> map2) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        Set<Map.Entry<String, String>> set = map2.entrySet();
        for (Map.Entry<String, String> entry : set) {
            try {
                icbcHashMap.put(entry.getKey(), URLEncoder.encode(entry.getValue(), string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IcbcApiException((Throwable)unsupportedEncodingException);
            }
        }
        return WebUtils.doGet(string, map, (Map<String, String>)icbcHashMap, string2);
    }

    public static String doPost(String string, Map<String, String> map, String string2, String string3) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        icbcHashMap.put("Zone-No", string3);
        return WebUtils.doPost(string, map, (Map<String, String>)icbcHashMap, string2);
    }

    public static String doGet(String string, Map<String, String> map, String string2, String string3) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        icbcHashMap.put("Zone-No", string3);
        return WebUtils.doGet(string, map, (Map<String, String>)icbcHashMap, string2);
    }

    public static String doPost(String string, String string2, String string3) throws IcbcApiException {
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        icbcHashMap.put("APIGW-VERSION", version);
        return WebUtils.doPost(string, string2, (Map<String, String>)icbcHashMap, string3);
    }

    public static String doPost(String string, String string2, Map<String, String> map, String string3) throws IcbcApiException {
        StringEntity stringEntity = new StringEntity(string2, string3);
        return WebUtils.doPost(string, stringEntity, map, string3);
    }

    public static String doPost(String string, Map<String, String> map, Map<String, String> map2, String string2) throws IcbcApiException {
        return WebUtils.doPost(string, WebUtils.buildPostHttpEntity(map, string2), map2, string2);
    }

    public static String doPost(String string, HttpEntity httpEntity, Map<String, String> map, String string2) throws IcbcApiException {
        HttpPost httpPost = new HttpPost(string);
        httpPost.setEntity(httpEntity);
        if (map != null) {
            WebUtils.addHeaders(httpPost, map);
        }
        return WebUtils.execute(httpPost);
    }

    public static String doGet(String string, Map<String, String> map, Map<String, String> map2, String string2) throws IcbcApiException {
        String string3 = WebUtils.buildGetUrl(string, map, string2);
        HttpGet httpGet = new HttpGet(string3);
        if (map2 != null) {
            WebUtils.addHeaders(httpGet, map2);
        }
        return WebUtils.execute(httpGet);
    }

    public static String execute(HttpUriRequest httpUriRequest) throws IcbcApiException {
        HttpResponse httpResponse;
        try {
            httpResponse = HttpClientUtils.getSyncHttpClient().execute(httpUriRequest);
        }
        catch (ClientProtocolException clientProtocolException) {
            logger.error((Object)"execute request exception.", (Throwable)clientProtocolException);
            throw new IcbcApiException("execute request exception.", (Throwable)clientProtocolException);
        }
        catch (IOException iOException) {
            logger.error((Object)"execute request exception.", (Throwable)iOException);
            throw new IcbcApiException("execute request exception.", (Throwable)iOException);
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        HttpEntity httpEntity = httpResponse.getEntity();
        try {
            String string = EntityUtils.toString(httpEntity, WebUtils.getResponseEncoding(httpEntity));
            if (n != 200) {
                logger.error((Object)("response status code is not valid. status code: " + n));
                throw new IcbcApiException("response status code is not valid. status code: " + n + " resp is:" + string);
            }
            return string;
        }
        catch (ParseException parseException) {
            logger.error((Object)"parse respose exception.", (Throwable)parseException);
            throw new IcbcApiException("parse respose exception.", (Throwable)parseException);
        }
        catch (IOException iOException) {
            logger.error((Object)"io exception.", (Throwable)iOException);
            throw new IcbcApiException("io exception.", (Throwable)iOException);
        }
    }

    public static String getResponseEncoding(HttpEntity httpEntity) {
        String string;
        Matcher matcher;
        Header header = httpEntity.getContentType();
        if (header != null && (matcher = CHARSET_PATTERN.matcher(string = header.getValue().replace(" ", ""))).find()) {
            return matcher.group(1);
        }
        return CHARSET_UTF8;
    }

    public static HttpEntity buildPostHttpEntity(Map<String, String> map, String string) throws IcbcApiException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            return new UrlEncodedFormEntity(arrayList, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)"urlencode post request exception.", (Throwable)unsupportedEncodingException);
            throw new IcbcApiException("urlencode post request exception.", (Throwable)unsupportedEncodingException);
        }
    }

    public static String buildGetUrl(String string, Map<String, String> map, String string2) throws IcbcApiException {
        if (map == null || map.size() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        try {
            if (StringUtils.isEmpty((String)new URL(string).getQuery()) && !string.endsWith("?")) {
                stringBuilder.append('?');
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("url exception. url: " + string), (Throwable)malformedURLException);
            throw new IcbcApiException("url exception. url: " + string, (Throwable)malformedURLException);
        }
        Set<Map.Entry<String, String>> set = map.entrySet();
        boolean bl = false;
        boolean bl2 = string.contains("?") ? !string.endsWith("&") : false;
        for (Map.Entry<String, String> entry : set) {
            String string3;
            String string4 = entry.getKey();
            if (!StringUtils.areNotEmpty((String[])new String[]{string4, string3 = entry.getValue()})) continue;
            if (bl) {
                stringBuilder.append("&");
            } else {
                if (bl2) {
                    stringBuilder.append("&");
                }
                bl = true;
            }
            try {
                stringBuilder.append(string4).append("=").append(URLEncoder.encode(string3, string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)("param urlencode exception. value: " + string3), (Throwable)unsupportedEncodingException);
                throw new IcbcApiException("param urlencode exception. value: " + string3, (Throwable)unsupportedEncodingException);
            }
        }
        return stringBuilder.toString();
    }

    public static String buildOrderedSignStr(String string, Map<String, String> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.putAll(map);
        Set set = treeMap.entrySet();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("?");
        for (Map.Entry entry : set) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (!StringUtils.areNotEmpty((String[])new String[]{string2, string3})) continue;
            if (bl) {
                stringBuilder.append("&");
            } else {
                bl = true;
            }
            stringBuilder.append(string2).append("=").append(string3);
        }
        return stringBuilder.toString();
    }

    private WebUtils() {
    }

    public static String buildForm(String string, Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<form name=\"auto_submit_form\" method=\"post\" action=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">\n");
        stringBuffer.append(WebUtils.buildHiddenFields(map));
        stringBuffer.append("<input type=\"submit\" value=\"\u7acb\u523b\u63d0\u4ea4\" style=\"display:none\" >\n");
        stringBuffer.append("</form>\n");
        stringBuffer.append("<script>document.forms[0].submit();</script>");
        String string2 = stringBuffer.toString();
        return string2;
    }

    private static String buildHiddenFields(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Set<String> set = map.keySet();
        for (String string : set) {
            String string2 = map.get(string);
            if (string == null || string2 == null) continue;
            stringBuffer.append(WebUtils.buildHiddenField(string, string2));
        }
        String string = stringBuffer.toString();
        return string;
    }

    private static String buildHiddenField(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<input type=\"hidden\" name=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" value=\"");
        String string3 = string2.replace("\"", "&quot;");
        stringBuffer.append(string3).append("\">\n");
        return stringBuffer.toString();
    }

    private static void addHeaders(HttpUriRequest httpUriRequest, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (!StringUtils.areNotEmpty((String[])new String[]{string, string2})) continue;
            httpUriRequest.addHeader(string, string2);
        }
    }
}

