/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lib.dc.services.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lib.dc.services.utils.MessageUtils;
import kd.ebg.aqap.banks.lib.dc.services.utils.Response;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class IESI309020
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        JSONObject body = new JSONObject();
        body.put("accountNo", (Object)((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)).getAccNo());
        body.put("startDate", (Object)bankBalanceRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        body.put("endDate", (Object)bankBalanceRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        return MessageUtils.send(body, this.getBizCode());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Response response = MessageUtils.receive(s);
        response.checkStatus();
        JSONObject data = response.getBody();
        JSONArray balanceInfoList = data.getJSONArray("balanceInfoList");
        int size = CollectionUtil.isEmpty((Collection)balanceInfoList) ? 0 : balanceInfoList.size();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(8);
        for (int i = 0; i < size; ++i) {
            JSONObject bankBalance = balanceInfoList.getJSONObject(i);
            BalanceInfo balanceInfo = new BalanceInfo();
            String currentBalance = bankBalance.getString("acctBal");
            String accountNo = bankBalance.getString("accountNo");
            String balDate = bankBalance.getString("balDate");
            String currency = bankBalance.getString("currency");
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), accountNo);
            this.setBalanceDate(balanceInfo, balDate, DateTimeFormatter.BASIC_ISO_DATE);
            this.setBankCurrency(balanceInfo, currency);
            this.setCurrentBalance(balanceInfo, currentBalance);
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "IESI309020";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"IESI309020_0", (String)"ebg-aqap-banks-lib-dc", (Object[])new Object[0]);
    }

    public LocalDate limitDate() {
        return null;
    }
}

