/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lib.dc.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lib.dc.services.utils.MessageUtils;
import kd.ebg.aqap.banks.lib.dc.services.utils.Response;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class IESI309012
extends AbstractDetailImpl
implements IDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(IESI309012.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        JSONObject body = new JSONObject();
        body.put("accountNo", (Object)bankDetailRequest.getAcnt().getAccNo());
        body.put("queryDate", (Object)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        int p = Integer.parseInt(this.getCurrentPage());
        if (p == 0) {
            this.setCurrentPage(1);
            p = 1;
        }
        body.put("pageNo", (Object)p);
        body.put("pageSize", (Object)10);
        return MessageUtils.send(body, this.getBizCode());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        Response response = MessageUtils.receive(s);
        response.checkStatus();
        JSONObject data = response.getBody();
        String accountNo = data.getString("accountNo");
        String accountName = data.getString("accountName");
        int totalRecord = data.getIntValue("totalRecord");
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(8);
        if (totalRecord > 0) {
            JSONArray acctTranDetailList = data.getJSONArray("acctTranDetailList");
            int size = CollectionUtil.isEmpty((Collection)acctTranDetailList) ? 0 : acctTranDetailList.size();
            for (int i = 0; i < size; ++i) {
                try {
                    JSONObject acctDetail = acctTranDetailList.getJSONObject(i);
                    DetailInfo detailInfo = MessageUtils.parseDetail(acctDetail);
                    detailInfo.setAccNo(accountNo);
                    detailInfo.setAccName(accountName);
                    detailInfoList.add(detailInfo);
                    continue;
                }
                catch (Exception e) {
                    logger.info("\u89e3\u6790\u7b2c{}\u6761\u660e\u7ec6\u5931\u8d25\u3002", (Object)i);
                }
            }
            int p = Integer.parseInt(this.getCurrentPage());
            if (totalRecord > p * 10) {
                this.setLastPage(false);
                this.setCurrentPage(p + 1);
            }
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "IESI309012";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5355\u65e5\u660e\u7ec6\u5217\u8868\u67e5\u8be2", (String)"IESI309012_0", (String)"ebg-aqap-banks-lib-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

