/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lib.dc.services.payment;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lib.dc.services.payment.IESI309008;
import kd.ebg.aqap.banks.lib.dc.services.utils.MessageUtils;
import kd.ebg.aqap.banks.lib.dc.services.utils.Response;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;

public class IESI309005
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IESI309008.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = new JSONObject();
        body.put("transId", (Object)paymentInfo.getBankBatchSeqID());
        body.put("accountNo", (Object)paymentInfo.getAccNo());
        body.put("debitAcctName", (Object)paymentInfo.getAccName());
        body.put("creditAcctNo", (Object)paymentInfo.getIncomeAccNo());
        body.put("creditAcctName", (Object)paymentInfo.getIncomeAccName());
        body.put("amount", (Object)paymentInfo.getAmount());
        body.put("currency", (Object)paymentInfo.getCurrency());
        body.put("paymentUsage", (Object)paymentInfo.getExplanation());
        body.put("addtlInf", (Object)paymentInfo.getExplanation());
        return MessageUtils.send(body, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Response response = MessageUtils.receive(s);
        if (response.isSuccess()) {
            JSONObject data = response.getBody();
            int transStatus = data.getIntValue("transStatus");
            if (transStatus >= 0 && transStatus < 3) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)String.valueOf(transStatus), (String)"");
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)String.valueOf(transStatus), (String)"");
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getRespCode(), (String)response.getRespMsg());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "IESI309005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"IESI309005_0", (String)"ebg-aqap-banks-lib-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

