/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lib.dc.services.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lib.dc.services.utils.Response;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MessageUtils {
    public static final int PAGE_SIZE = 10;

    public static String createHeadRoot(JSONObject body, String txnCode) {
        String cust_Id = RequestContextUtils.getBankParameterValue((String)"userid");
        JSONObject head = new JSONObject();
        head.put("custId", (Object)cust_Id);
        head.put("version", (Object)"1.0");
        head.put("txnCode", (Object)txnCode);
        head.put("local", (Object)"zh_CN");
        head.put("reqTime", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        head.put("extRefId", (Object)Sequence.genSequence());
        head.put("body", (Object)body);
        return head.toJSONString();
    }

    public static String send(JSONObject body, String txnCode) {
        String root = MessageUtils.createHeadRoot(body, txnCode);
        return XMB_Packer.sign((String)root);
    }

    public static Response receive(String s) {
        JSONObject root = JSON.parseObject((String)s);
        String respCode = root.getString("respCode");
        String respMsg = root.getString("respMsg");
        JSONObject body = root.getJSONObject("body");
        return new Response(respCode, respMsg, body);
    }

    public static DetailInfo parseDetail(JSONObject acctDetail) {
        DetailInfo detailInfo = new DetailInfo();
        String tranDate = acctDetail.getString("tranDate");
        String tranTime = acctDetail.getString("tranTime");
        tranDate = StringUtils.isEmpty((String)tranTime) ? tranDate + "000000" : tranDate + tranTime;
        LocalDateTime transDateTime = LocalDateTime.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        detailInfo.setTransTime(transDateTime);
        detailInfo.setTransDate(transDateTime.toLocalDate());
        detailInfo.setCurrency(acctDetail.getString("currency"));
        detailInfo.setDebitAmount(acctDetail.getBigDecimal("debitAmt"));
        detailInfo.setCreditAmount(acctDetail.getBigDecimal("creditAmt"));
        detailInfo.setBalance(acctDetail.getBigDecimal("closingBal"));
        detailInfo.setExplanation(acctDetail.getString("addtlInf"));
        String cbsToAcctNo = acctDetail.getString("cbsToAcctNo");
        detailInfo.setOppAccNo(cbsToAcctNo);
        String cbsToAcctName = acctDetail.getString("cbsToAcctName");
        detailInfo.setOppAccName(cbsToAcctName);
        String cbsToAcctBranchNm = acctDetail.getString("cbsToAcctBranchNm");
        detailInfo.setOppBankName(cbsToAcctBranchNm);
        detailInfo.setBankDetailNo(acctDetail.getString("bankSerialNo"));
        detailInfo.setJsonMap(acctDetail.toJSONString());
        return detailInfo;
    }

    public static void handlePayment(PaymentInfo paymentInfo, JSONObject data) {
        String errMsg;
        String errCode;
        int transStatus;
        String transStatusStr = data.getString("transStatus");
        if (StringUtils.isEmpty((String)transStatusStr)) {
            transStatus = -1;
            errCode = "-1";
            errMsg = ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u4ea4\u6613\u72b6\u6001\u4fe1\u606f\uff0c\u4ea4\u6613\u72b6\u6001\u672a\u77e5\u3002", (String)"MessageUtils_0", (String)"ebg-aqap-banks-lib-dc", (Object[])new Object[0]);
        } else {
            try {
                transStatus = Integer.parseInt(transStatusStr);
            }
            catch (NumberFormatException ignore) {
                transStatus = -1;
            }
            errCode = data.getString("errCode");
            errMsg = data.getString("errMsg");
        }
        if (StringUtils.isEmpty((String)errCode)) {
            errCode = transStatusStr;
        }
        if (StringUtils.isEmpty((String)errMsg)) {
            errMsg = "";
        }
        if (transStatus == 0) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)"", (String)"");
        } else if (transStatus == 1) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)errCode, (String)errMsg);
        } else if (transStatus == 2) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)transStatusStr, (String)errCode, (String)errMsg);
        }
    }
}

