/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.cmp.services.payment.salary;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.PackHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.ParserHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImplWithPage;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImplWithPage
implements IQueryPay {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element body = JDomUtils.createRoot((String)"body");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pager", (String)"true");
        JDomUtils.addChild((Element)body, (String)"size", (String)"10");
        JDomUtils.addChild((Element)body, (String)"start", (String)this.getCurrentPage());
        return PackHelper.getPackMessage((String)"01603020104A0217", (String)Sequence.genSequence(), (Element)body);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        this.setLastPage(true);
        BankResponse rsp = ParserHelper.buildHeadMessage((String)res);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element body = ParserHelper.getBodyMessage((String)res);
        if (body.getChild("array") == null) {
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        String total = body.getChildText("total");
        this.handPage(total);
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        Element array = body.getChild("array");
        List dtos = array.getChildren("dto");
        for (Element element : dtos) {
            String oppAcctNo = element.getChildText("oppAcctNo");
            String oppAcctName = element.getChildText("oppAcctName");
            String amt = element.getChildText("amt");
            String tfrStat = element.getChildText("tfrStat");
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(oppAcctNo, oppAcctName, amt);
            bankResPaymentInfo.setBankStatus(tfrStat);
            if ("S".equals(tfrStat)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("F".equals(tfrStat)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else if ("P".equals(tfrStat) || "A".equals(tfrStat)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).getBankBatchSeqID());
        return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "01603020104A0217";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u6279\u6b21\u660e\u7ec6\u67e5\u8be2", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public Boolean SupportPage() {
        return true;
    }

    private void handPage(String total) {
        if (StringUtils.isNotEmpty((String)total)) {
            int totalCount = Integer.parseInt(total);
            String currentPage = this.getCurrentPage();
            int count = Integer.parseInt(currentPage) + 10;
            if (count - 1 < totalCount) {
                this.setLastPage(false);
                this.setCurrentPage(count);
                return;
            }
        }
        this.setLastPage(true);
    }
}

