/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.mservice.boot.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceStatementResponse;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.testnet.PingException;
import kd.ebg.aqap.common.utils.LogSubTypeConvert;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.mservice.boot.handler.filter.IdentificationCodeHandler;
import kd.ebg.aqap.mservice.lang.MultiLang;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.exception.EBDbSaveException;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBExceptionEnum;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.connect.TestBankConnection;
import kd.ebg.egf.common.framework.biz.BizTypeEnum;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.license.EbgLicenseUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.repository.monitor.BankReqRecordRepository;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;
import org.slf4j.MDC;

public class EBServiceHandlerEnhance<REQ extends EBRequest, RSP extends EBResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(EBServiceHandlerEnhance.class);
    private static final String REQUEST_SEQ_ID_KEY = "requestSeqID";
    private static final String BIZ_NAME_KEY = "bizName";
    private static final String BIZ_SEQ_KEY = "bizSeqID";
    private static final String CUSTOMER_ID = "customerID";
    private static final String BANK_VERSION_ID = "bankVersionID";
    private static final String TYPE = "type";
    private BankAcntRepository bankAcntRepository;
    private BankLoginRepository bankLoginRepository;
    private static final List<String> NOT_CHECK_ACCNO_BIZTYPE_LIST = Arrays.asList("listBankLogin", "syncAccount", "register", "apply", "cert");
    private static final RateLimiter globalRateLimiter = RateLimiter.create((double)200.0);
    private static final long maxWaitTime = 30L;
    private static final AtomicInteger rateLimiterRejectCount = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, RateLimiter> customRateLimiter = new ConcurrentHashMap();
    private final Class<REQ> requestClass;
    private final Class<RSP> responseClass;
    private final String method;
    private final EBServiceMethod<REQ, RSP> serviceMethod;

    public EBServiceHandlerEnhance(String method, EBServiceMethod<REQ, RSP> serviceMethod, Class<REQ> requestClass, Class<RSP> responseClass) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)method), (Object)MultiLang.getEmptyCheckTip((String)"method"));
        Preconditions.checkArgument((boolean)Objects.nonNull(serviceMethod), (Object)MultiLang.getEmptyCheckTip((String)"serviceMethod"));
        Preconditions.checkArgument((boolean)Objects.nonNull(requestClass), (Object)MultiLang.getEmptyCheckTip((String)"request entity class"));
        Preconditions.checkArgument((boolean)Objects.nonNull(responseClass), (Object)MultiLang.getEmptyCheckTip((String)"reponse entity class"));
        this.method = method;
        this.serviceMethod = serviceMethod;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public RSP handle(String data, String customId) {
        EBRequest req = (EBRequest)JsonUtil.json2Obj((String)data, this.requestClass);
        req.getHeader().setCustomId(customId);
        req.getHeader().setLogBizSeqID(Sequence.gen18Sequence());
        req.getHeader().setLogRequestSeqID(String.valueOf(req.getHeader().getRequestTime()));
        return this.handle(req);
    }

    private RSP getPreErrorResponse(REQ request, String errorMsg) {
        return this.getPreErrorResponse(request, null, errorMsg);
    }

    private RSP getPreErrorResponse(REQ request, String errorCode, String errorMsg) {
        EBResponse response = (EBResponse)ReflectUtil.newInstance(this.responseClass);
        response.setHeader(request.getHeader());
        EBHeader header = response.getHeader();
        if (Objects.nonNull(header)) {
            header.setResponseTime(System.currentTimeMillis());
        }
        EBException ebException = new EBException();
        ebException.setMessage(errorMsg);
        if (StringUtils.isEmpty((String)errorCode)) {
            ebException.setErrorCode("preException");
        } else {
            ebException.setErrorCode(errorCode);
        }
        ebException.setInnerException("preException");
        response.setException(ebException);
        if (EBContext.getContext() != null) {
            int state = EBContext.getContext().getProcessFlag();
            ebException.setConnectionException(EBExceptionEnum.isConnectionException((int)state));
        }
        return (RSP)response;
    }

    private RSP getBizErrorResponse(REQ request, Throwable throwable) {
        String errorMsg;
        EBResponse response = (EBResponse)ReflectUtil.newInstance(this.responseClass);
        response.setHeader(request.getHeader());
        EBHeader header = response.getHeader();
        if (Objects.nonNull(header)) {
            header.setResponseTime(System.currentTimeMillis());
        }
        EBException ebException = new EBException();
        ebException.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])throwable.getStackTrace()));
        ebException.setErrorCode("serviceException");
        ebException.setInnerException("serviceException");
        String string = errorMsg = throwable == null ? null : throwable.getMessage();
        if (throwable instanceof EBDuplicateException) {
            errorMsg = throwable.getMessage();
            ebException.setErrorCode("preException");
            ebException.setInnerException(((EBDuplicateException)throwable).getErrorCode());
        } else if (throwable instanceof EBDbSaveException) {
            errorMsg = throwable.getMessage();
            ebException.setErrorCode("serviceException");
            ebException.setInnerException(((EBDbSaveException)throwable).getErrorCode());
        } else if (throwable != null && throwable.getCause() != null && throwable.getCause().getMessage() != null && throwable.getMessage() != null && !throwable.getMessage().contains(throwable.getCause().getMessage())) {
            errorMsg = errorMsg + (Objects.isNull(throwable.getCause()) ? "" : throwable.getCause().getMessage());
        }
        if (StringUtils.isNotEmpty((String)EBContext.getContext().getExceptionMsg())) {
            ebException.setMessage(EBContext.getContext().getExceptionMsg());
        } else {
            ebException.setMessage(errorMsg);
        }
        ebException.setCorrelationID(RequestContext.get().getTraceId());
        ebException.setTime(String.valueOf(System.currentTimeMillis()));
        response.setException(ebException);
        if (EBContext.getContext() != null) {
            int state = EBContext.getContext().getProcessFlag();
            ebException.setConnectionException(EBExceptionEnum.isConnectionException((int)state));
        }
        return (RSP)response;
    }

    private synchronized RateLimiter createForCustom(String customId) {
        RateLimiter rateLimiter = customRateLimiter.get(customId);
        if (Objects.isNull(rateLimiter)) {
            rateLimiter = RateLimiter.create((double)100.0);
            customRateLimiter.put(customId, rateLimiter);
        }
        return rateLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RSP handle(REQ request) {
        block77: {
            block75: {
                block76: {
                    block69: {
                        block74: {
                            block72: {
                                block73: {
                                    block70: {
                                        block71: {
                                            block68: {
                                                block66: {
                                                    block67: {
                                                        block64: {
                                                            block65: {
                                                                block62: {
                                                                    block63: {
                                                                        block60: {
                                                                            block61: {
                                                                                block58: {
                                                                                    block59: {
                                                                                        block56: {
                                                                                            block57: {
                                                                                                block54: {
                                                                                                    block55: {
                                                                                                        block52: {
                                                                                                            block53: {
                                                                                                                this.bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
                                                                                                                this.bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);
                                                                                                                currentMs = System.currentTimeMillis();
                                                                                                                MDC.put((String)"requestSeqID", (String)"");
                                                                                                                MDC.put((String)"bizSeqID", (String)"");
                                                                                                                MDC.put((String)"customerID", (String)"");
                                                                                                                MDC.put((String)"bizName", (String)"");
                                                                                                                MDC.put((String)"bankVersionID", (String)"");
                                                                                                                MDC.put((String)"type", (String)"");
                                                                                                                h = TX.notSupported();
                                                                                                                tryAcquire = EBServiceHandlerEnhance.globalRateLimiter.tryAcquire(30L, TimeUnit.SECONDS);
                                                                                                                if (tryAcquire) break block52;
                                                                                                                EBServiceHandlerEnhance.log.info("\u89e6\u53d1\u5168\u5c40\u9650\u6d41");
                                                                                                                EBServiceHandlerEnhance.rateLimiterRejectCount.incrementAndGet();
                                                                                                                var6_6 = this.getPreErrorResponse(request, MultiLang.getLimitTip());
                                                                                                                if (h == null) break block53;
                                                                                                                h.close();
                                                                                                            }
                                                                                                            cost = System.currentTimeMillis() - currentMs;
                                                                                                            EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                                            EBContext.destroy();
                                                                                                            return var6_6;
                                                                                                        }
                                                                                                        header = request.getHeader();
                                                                                                        accountNo = header.getAccNo();
                                                                                                        customId = header.getCustomId();
                                                                                                        bankVersion = "";
                                                                                                        bankLogin = header.getBankVersion();
                                                                                                        if (StringUtils.isEmpty((String)bankLogin)) ** GOTO lbl57
                                                                                                        bankLoginInfo = this.bankLoginRepository.findById(bankLogin, customId);
                                                                                                        if (bankLoginInfo != null) break block54;
                                                                                                        var12_15 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBServiceHandlerEnhance_11", (String)"ebg-aqap-mservice", (Object[])new Object[0]), new Object[]{bankLogin}));
                                                                                                        if (h == null) break block55;
                                                                                                        h.close();
                                                                                                    }
                                                                                                    cost = System.currentTimeMillis() - currentMs;
                                                                                                    EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                                    EBContext.destroy();
                                                                                                    return var12_15;
                                                                                                }
                                                                                                if (!bankLoginInfo.getEnable().equals("0")) break block56;
                                                                                                var12_16 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a[%s]\u5df2\u88ab\u5220\u9664\u3002", (String)"EBServiceHandlerEnhance_19", (String)"ebg-aqap-mservice", (Object[])new Object[0]), new Object[]{bankLogin}));
                                                                                                if (h == null) break block57;
                                                                                                h.close();
                                                                                            }
                                                                                            cost = System.currentTimeMillis() - currentMs;
                                                                                            EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                            EBContext.destroy();
                                                                                            return var12_16;
                                                                                        }
                                                                                        bankVersion = bankLoginInfo.getBankVersionId();
lbl57:
                                                                                        // 2 sources

                                                                                        bankAcnt = null;
                                                                                        if (!StringUtils.isEmpty((String)bankVersion) && EBServiceHandlerEnhance.NOT_CHECK_ACCNO_BIZTYPE_LIST.contains(header.getBizType()) || accountNo == null) break block58;
                                                                                        bankAcnt = this.bankAcntRepository.findByAccNoAndCustomID(accountNo, customId);
                                                                                        if (bankAcnt != null) {
                                                                                            bankVersion = bankAcnt.getBankVersionId();
                                                                                            break block58;
                                                                                        }
                                                                                        var12_17 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u8d26\u53f7[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBServiceHandlerEnhance_12", (String)"ebg-aqap-mservice", (Object[])new Object[0]), new Object[]{accountNo}));
                                                                                        if (h == null) break block59;
                                                                                        h.close();
                                                                                    }
                                                                                    cost = System.currentTimeMillis() - currentMs;
                                                                                    EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                    EBContext.destroy();
                                                                                    return var12_17;
                                                                                }
                                                                                rateLimiter = EBServiceHandlerEnhance.customRateLimiter.get(customId);
                                                                                if (Objects.isNull(rateLimiter)) {
                                                                                    rateLimiter = this.createForCustom(customId);
                                                                                }
                                                                                if (rateLimiter.tryAcquire(30L, TimeUnit.SECONDS)) break block60;
                                                                                EBServiceHandlerEnhance.log.info("\u79df\u6237:{} \u89e6\u53d1\u9650\u6d41", (Object)customId);
                                                                                cost = this.getPreErrorResponse(request, MultiLang.getSingleLimitTip());
                                                                                if (h == null) break block61;
                                                                                h.close();
                                                                            }
                                                                            cost = System.currentTimeMillis() - currentMs;
                                                                            EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                            EBContext.destroy();
                                                                            return cost;
                                                                        }
                                                                        logBizSeqID = request.getHeader().getLogBizSeqID();
                                                                        if (StringUtils.isEmpty((String)logBizSeqID)) {
                                                                            logBizSeqID = Sequence.gen18Sequence();
                                                                        }
                                                                        if (StringUtils.isEmpty((String)header.getLogRequestSeqID())) {
                                                                            header.setLogRequestSeqID(String.valueOf(header.getRequestTime()));
                                                                        }
                                                                        extDate = request.getHeader().getExtData();
                                                                        loggerBatchNo = "";
                                                                        loggerDetailNo = "";
                                                                        loggerBankNo = "";
                                                                        if (extDate != null) {
                                                                            object = JSONObject.fromObject((Object)extDate);
                                                                            loggerBatchNo = (String)object.get("loggerBatchNo");
                                                                            loggerDetailNo = (String)object.get("loggerDetailNo");
                                                                            loggerBankNo = (String)object.get("loggerBankNo");
                                                                        } else {
                                                                            defaultNo = request.getHeader().getBizSeqID();
                                                                            if (StringUtils.isEmpty((String)defaultNo)) {
                                                                                defaultNo = Sequence.gen18Sequence();
                                                                            }
                                                                            loggerBatchNo = defaultNo;
                                                                            loggerDetailNo = defaultNo;
                                                                            loggerBankNo = defaultNo;
                                                                        }
                                                                        context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).logRequestSeqID(header.getLogRequestSeqID()).bizName(header.getBizType()).subBizName(header.getSubBizType()).bankVersionID(bankVersion).logBizSeqID(logBizSeqID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(loggerBatchNo).loggerDetailNo(loggerDetailNo).loggerBankNo(loggerBankNo).build();
                                                                        if (bankAcnt != null) {
                                                                            context.setBankAcnt(bankAcnt);
                                                                            context.setBankVersionID(bankAcnt.getBankVersionId());
                                                                            context.setBankLoginID(bankAcnt.getBankLoginId());
                                                                        }
                                                                        MDCUtil.clearBankMDC();
                                                                        MDCUtil.initMDC((EBContext)context);
                                                                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                                                                        MDC.put((String)"requestSeqID", (String)context.getRequestSeqID());
                                                                        MDC.put((String)"bizSeqID", (String)context.getBizSeqID());
                                                                        MDC.put((String)"customerID", (String)context.getCustomID());
                                                                        MDC.put((String)"bizName", (String)context.getBizName());
                                                                        MDC.put((String)"bankVersionID", (String)context.getBankVersionID());
                                                                        MDC.put((String)"clientName", (String)header.getClientName());
                                                                        try {
                                                                            loggersubBizType = LogSubTypeConvert.convertLogType((String)header.getBizType(), request);
                                                                            context.setLogger_sub_type(loggersubBizType);
                                                                        }
                                                                        catch (Throwable t) {
                                                                            EBServiceHandlerEnhance.log.warn("\u5b50\u4e1a\u52a1\u7c7b\u578b\u5904\u7406\u5f02\u5e38", new Object[]{t});
                                                                        }
                                                                        if ("batchBalance".equalsIgnoreCase(header.getBizType()) || "balance".equalsIgnoreCase(header.getBizType()) || "balanceStatement".equalsIgnoreCase(header.getBizType()) || "balanceReconciliation".equalsIgnoreCase(header.getBizType()) || "queryBalanceReconciliation".equalsIgnoreCase(header.getBizType()) || "updateBalanceReconciliationStatus".equalsIgnoreCase(header.getBizType()) || "detail".equalsIgnoreCase(header.getBizType()) || "listBankLogin".equalsIgnoreCase(header.getBizType()) || "ping".equalsIgnoreCase(header.getBizType()) || "listBank".equalsIgnoreCase(header.getBizType()) || "pay".equalsIgnoreCase(header.getBizType()) || "syncAccount".equalsIgnoreCase(header.getBizType()) || "overseaPay".equalsIgnoreCase(header.getBizType()) || "linkpay".equalsIgnoreCase(header.getBizType()) || "queryLinkpay".equalsIgnoreCase(header.getBizType()) || "queryPay".equalsIgnoreCase(header.getBizType()) || "queryOverseaPay".equalsIgnoreCase(header.getBizType()) || "syncMappedAcct".equalsIgnoreCase(header.getBizType()) || "queryCredit".equalsIgnoreCase(header.getBizType()) || "queryCreditReceived".equalsIgnoreCase(header.getBizType()) || "openCredit".equalsIgnoreCase(header.getBizType()) || "openCreditQuery".equalsIgnoreCase(header.getBizType()) || "register".equalsIgnoreCase(header.getBizType()) || "apply".equalsIgnoreCase(header.getBizType()) || "queryApply".equalsIgnoreCase(header.getBizType()) || "cancelApply".equalsIgnoreCase(header.getBizType()) || "cert".equalsIgnoreCase(header.getBizType()) || "downloadBankFile".equalsIgnoreCase(header.getBizType()) || "updatePayStatus".equalsIgnoreCase(header.getBizType()) || "currentAndFixed".equalsIgnoreCase(header.getBizType()) || "queryCurrentAndFixed".equalsIgnoreCase(header.getBizType()) || "updateCurAndFixedStatus".equalsIgnoreCase(header.getBizType()) || "withdrawFromNAcc".equalsIgnoreCase(header.getBizType()) || "cancelNotification".equalsIgnoreCase(header.getBizType()) || "queryFinancing".equalsIgnoreCase(header.getBizType()) || "buyFinancing".equalsIgnoreCase(header.getBizType()) || "queryBuyFinancing".equalsIgnoreCase(header.getBizType()) || "redeemFinancing".equalsIgnoreCase(header.getBizType()) || "queryRedeemFinancing".equalsIgnoreCase(header.getBizType()) || "updateFinancingStatus".equalsIgnoreCase(header.getBizType())) {
                                                                            EBServiceHandlerEnhance.log.infoIndex("\u5f00\u59cb\u8fdb\u884c\u4e1a\u52a1\u5904\u7406,{}", (Object)header.getBizType());
                                                                        }
                                                                        if ("ping".equalsIgnoreCase(header.getBizType()) && !StringUtils.isEmpty((String)header.getExtData())) {
                                                                            obj = JSON.parseObject((String)header.getExtData());
                                                                            bankVersion = obj.getString("bankVersionID");
                                                                            bankLogin = obj.getString("bankLoginID");
                                                                            context.setBankLoginID(bankLogin);
                                                                            context.setBankVersionID(bankVersion);
                                                                        }
                                                                        EBContext.setContext((EBContext)context);
                                                                        ipErrorMessage = this.checkIp();
                                                                        if (!StringUtils.isNotEmpty((String)ipErrorMessage)) break block62;
                                                                        var20_32 = this.getPreErrorResponse(request, ipErrorMessage);
                                                                        if (h == null) break block63;
                                                                        h.close();
                                                                    }
                                                                    cost = System.currentTimeMillis() - currentMs;
                                                                    EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                    EBContext.destroy();
                                                                    return var20_32;
                                                                }
                                                                if (!SystemPropertyConfig.isDatacenterCheckOpen()) break block64;
                                                                identificationCode /* !! */  = header.getIdentificationCode();
                                                                identificationCodeHandler = IdentificationCodeHandler.build();
                                                                if (identificationCodeHandler.handleIdentificationCode(customId, header.getClientName(), header.getClientVersion(), identificationCode /* !! */ )) break block64;
                                                                var22_38 = this.getPreErrorResponse(request, ResManager.loadKDString((String)"\u5ba2\u6237\u8ba4\u8bc1\u6807\u8bc6\u7801\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6570\u636e\u4e2d\u5fc3\u914d\u7f6e\u6b63\u786e\uff0c\u4e0b\u4e00\u4ee3\u9700\u8981\u914d\u7f6e\u8d26\u5957ID\u3002", (String)"EBServiceHandlerEnhance_3", (String)"ebg-aqap-mservice", (Object[])new Object[0]));
                                                                if (h == null) break block65;
                                                                h.close();
                                                            }
                                                            cost = System.currentTimeMillis() - currentMs;
                                                            EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                            EBContext.destroy();
                                                            return var22_38;
                                                        }
                                                        if (!"detail".equalsIgnoreCase(this.method) || this.checkQueryDetail(accountNo)) break block66;
                                                        identificationCode /* !! */  = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\uff1a%s\uff0c\u4e0d\u5141\u8bb8\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u3002", (String)"EBServiceHandlerEnhance_13", (String)"ebg-aqap-mservice", (Object[])new Object[0]), new Object[]{accountNo}));
                                                        if (h == null) break block67;
                                                        h.close();
                                                    }
                                                    cost = System.currentTimeMillis() - currentMs;
                                                    EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                    EBContext.destroy();
                                                    return (RSP)identificationCode /* !! */ ;
                                                }
                                                EBServiceHandlerEnhance.log.debug("\u8c03\u7528 {} \u4e1a\u52a1\u63a5\u53e3", (Object)this.method);
                                                headerCurrency = request.getHeader().getCurrency();
                                                needCheckCurrency = headerCurrency != null;
                                                mappingCurrency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(headerCurrency);
                                                request.getHeader().setCurrency(mappingCurrency);
                                                if (this.method.contains("ping") || !needCheckCurrency) break block68;
                                                try {
                                                    CurrencyUtils.checkIsoCurrency((String)mappingCurrency);
                                                }
                                                catch (Throwable e) {
                                                    response = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u94f6\u4f01\u652f\u6301\u7684\u6807\u51c6\u5e01\u79cd\u3002", (String)"EBServiceHandlerEnhance_14", (String)"ebg-aqap-mservice", (Object[])new Object[0]), new Object[]{mappingCurrency}));
                                                    response.getHeader().setCurrency(headerCurrency);
                                                    var25_49 = response;
                                                    if (h != null) {
                                                        h.close();
                                                    }
                                                    cost = System.currentTimeMillis() - currentMs;
                                                    EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                    EBContext.destroy();
                                                    return var25_49;
                                                }
                                            }
                                            if (!this.serviceMethod.needCheckAccNo()) break block69;
                                            accNo = header.getAccNo();
                                            acnt = this.bankAcntRepository.findEnableByAccNo(accNo);
                                            if (null != acnt) break block70;
                                            response = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u4e86\u94f6\u4f01\u4e91\u4e2d\u672a\u7ef4\u62a4\u7684\u8d26\u53f7:%s\u3002", (String)"EBServiceHandlerEnhance_15", (String)"ebg-aqap-mservice", (Object[])new Object[0]), new Object[]{accNo}));
                                            response.getHeader().setCurrency(headerCurrency);
                                            cost = response;
                                            if (h == null) break block71;
                                            h.close();
                                        }
                                        cost = System.currentTimeMillis() - currentMs;
                                        EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                        EBContext.destroy();
                                        return cost;
                                    }
                                    context.setBankAcnt(acnt);
                                    if (StringUtils.isEmpty((String)bankLogin)) {
                                        context.setBankLoginID(acnt.getBankLoginId());
                                        context.setBankVersionID(acnt.getBankVersionId());
                                    } else {
                                        context.setBankLoginID(bankLogin);
                                        context.setBankVersionID(bankVersion);
                                    }
                                    if (this.checkBankLogin(context.getBankLoginID(), customId)) break block72;
                                    msg = ResManager.loadKDString((String)"\u8d26\u6237\u7ed1\u5b9a\u94f6\u884c\u524d\u7f6e\u673a\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u3010\u67e5\u8be2\u4e0e\u652f\u4ed8\u3011-\u3010\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u3011\u68c0\u67e5\u8d26\u6237\u7ed1\u5b9a\u7684\u524d\u7f6e\u673a\u662f\u5426\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"EBServiceHandlerEnhance_20", (String)"ebg-aqap-mservice", (Object[])new Object[0]);
                                    if ("pay".equals(request.getHeader().getBizType()) || "queryPay".equals(request.getHeader().getBizType())) {
                                        msg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u7ed1\u5b9a\u94f6\u884c\u524d\u7f6e\u673a\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u3010\u67e5\u8be2\u4e0e\u652f\u4ed8\u3011-\u3010\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u3011\u68c0\u67e5\u8d26\u6237\u7ed1\u5b9a\u7684\u524d\u7f6e\u673a\u662f\u5426\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"EBServiceHandlerEnhance_21", (String)"ebg-aqap-mservice", (Object[])new Object[0]);
                                    }
                                    cost = this.getPreErrorResponse(request, msg);
                                    if (h == null) break block73;
                                    h.close();
                                }
                                cost = System.currentTimeMillis() - currentMs;
                                EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                EBContext.destroy();
                                return cost;
                            }
                            errorMessage = EbgLicenseUtil.checkLicenseValid((String)customId, (String)header.getBizType(), (String)context.getBankLoginID());
                            if (!StrUtil.isNotBlank((CharSequence)errorMessage)) break block69;
                            response = this.getPreErrorResponse(request, errorMessage);
                            response.getHeader().setCurrency(headerCurrency);
                            cost = response;
                            if (h == null) break block74;
                            h.close();
                        }
                        cost = System.currentTimeMillis() - currentMs;
                        EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                        EBContext.destroy();
                        return cost;
                    }
                    MDC.put((String)"clientName", (String)request.getHeader().getClientName());
                    if (!BizTypeEnum.MOCK_PAY_TEST.getName().equalsIgnoreCase(request.getHeader().getOperationName()) && (testBankConnection = TestBankConnection.getInstance()).isNeedPing(context.getBizName()) && !(bankConnectResponse = testBankConnection.test(context.getCustomID(), context.getBankLoginID())).isSuccess()) {
                        BankReqRecordRepository.getInstance().saveLoginConnectTestFail(context, bankConnectResponse.getErrMsg());
                        EBContext.getContext().setProcessFlag(EBExceptionEnum.CONNECTION_EXCEPTION.getId());
                        throw EBExceiptionUtil.preCheckException((String)bankConnectResponse.getErrMsg());
                    }
                    this.serviceMethod.mappingCurrency(request);
                    response = this.serviceMethod.executeClientRequest(request, context);
                    response.setHeader(header);
                    header.setResponseTime(System.currentTimeMillis());
                    response.getHeader().setCurrency(headerCurrency);
                    this.serviceMethod.mappingCurrency(response);
                    if (!(response instanceof BalanceStatementResponse) || !CollectionUtil.isNotEmpty((Collection)(balanceStatementResponse = (BalanceStatementResponse)response).getBody().getBalanceStatements()) || !StrUtil.isNotBlank((CharSequence)(errorMessage = EbgLicenseUtil.checkLicenseValid((String)customId, (String)header.getBizType(), (String)context.getBankLoginID(), (boolean)true)))) break block75;
                    var26_58 = this.getPreErrorResponse(request, errorMessage);
                    if (h == null) break block76;
                    h.close();
                }
                cost = System.currentTimeMillis() - currentMs;
                EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                EBContext.destroy();
                return var26_58;
            }
            try {
                balanceStatementResponse = response;
                if (h == null) break block77;
            }
            catch (EBPreCheckException preCheckException) {
                block78: {
                    EBServiceHandlerEnhance.log.error("\u524d\u7f6e\u68c0\u67e5\u5f02\u5e38:", (Throwable)preCheckException);
                    errorResponse = this.getPreErrorResponse(request, preCheckException.getErrorCode(), preCheckException.getMessage());
                    errorResponse.getException().setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])preCheckException.getStackTrace()));
                    if (StringUtils.isNotEmpty((String)headerCurrency)) {
                        errorResponse.getHeader().setCurrency(headerCurrency);
                    }
                    var26_59 = errorResponse;
                    if (h == null) break block78;
                    h.close();
                }
                cost = System.currentTimeMillis() - currentMs;
                EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                EBContext.destroy();
                return var26_59;
                catch (IllegalArgumentException illegalArgumentException) {
                    block79: {
                        EBServiceHandlerEnhance.log.error("\u524d\u7f6e\u68c0\u67e5\u5f02\u5e38:", (Throwable)illegalArgumentException);
                        errorResponse = this.getPreErrorResponse(request, null, illegalArgumentException.getMessage());
                        errorResponse.getException().setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])illegalArgumentException.getStackTrace()));
                        if (StringUtils.isNotEmpty((String)headerCurrency)) {
                            errorResponse.getHeader().setCurrency(headerCurrency);
                        }
                        var26_60 = errorResponse;
                        if (h == null) break block79;
                        h.close();
                    }
                    cost = System.currentTimeMillis() - currentMs;
                    EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                    EBContext.destroy();
                    return var26_60;
                    catch (EBDuplicateException duplicateException) {
                        block80: {
                            EBServiceHandlerEnhance.log.error("\u524d\u7f6e\u68c0\u67e5\u5f02\u5e38:", (Throwable)duplicateException);
                            errorResponse = this.getPreErrorResponse(request, duplicateException.getErrorCode(), duplicateException.getMessage());
                            errorResponse.getException().setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])duplicateException.getStackTrace()));
                            if (StringUtils.isNotEmpty((String)headerCurrency)) {
                                errorResponse.getHeader().setCurrency(headerCurrency);
                            }
                            var26_61 = errorResponse;
                            if (h == null) break block80;
                            h.close();
                        }
                        cost = System.currentTimeMillis() - currentMs;
                        EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                        EBContext.destroy();
                        return var26_61;
                        catch (Throwable t) {
                            block81: {
                                try {
                                    EBServiceHandlerEnhance.log.error("\u94f6\u4f01\u4e2d\u95f4\u4ef6\u629b\u5411\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f02\u5e38:", t);
                                    errorResponse = this.getBizErrorResponse(request, t);
                                    if ("ping".equalsIgnoreCase(context.getBizName()) && t.getCause() != null) {
                                        if (t.getCause() instanceof EBServiceException && "ping_non".equalsIgnoreCase(((EBServiceException)t.getCause()).getErrorCode())) {
                                            errorResponse.getException().setErrorClass(PingException.class.getName());
                                        } else {
                                            errorResponse.getException().setErrorClass(t.getCause().getClass().getName());
                                        }
                                    }
                                    if (StringUtils.isNotEmpty((String)headerCurrency)) {
                                        errorResponse.getHeader().setCurrency(headerCurrency);
                                    }
                                    var26_62 = errorResponse;
                                    if (h == null) break block81;
                                }
                                catch (Throwable e) {
                                    block82: {
                                        try {
                                            h.markRollback();
                                            EBServiceHandlerEnhance.log.error("handle\u5904\u7406\u53d1\u751f\u5f02\u5e38", e);
                                            errorResponse = this.getPreErrorResponse(request, "", e.getMessage());
                                            errorResponse.getException().setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])e.getStackTrace()));
                                            var7_9 = errorResponse;
                                            if (h == null) break block82;
                                        }
                                        catch (Throwable var30_72) {
                                            if (h != null) {
                                                h.close();
                                            }
                                            cost = System.currentTimeMillis() - currentMs;
                                            EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                            EBContext.destroy();
                                            throw var30_72;
                                        }
                                        h.close();
                                    }
                                    cost = System.currentTimeMillis() - currentMs;
                                    EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                    EBContext.destroy();
                                    return var7_9;
                                }
                                h.close();
                            }
                            cost = System.currentTimeMillis() - currentMs;
                            EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                            EBContext.destroy();
                            return var26_62;
                        }
                    }
                }
            }
            h.close();
        }
        cost = System.currentTimeMillis() - currentMs;
        EBServiceHandlerEnhance.log.debug("\u5fae\u670d\u52a1\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
        EBContext.destroy();
        return (RSP)balanceStatementResponse;
    }

    private boolean checkBankLogin(String bankLoginID, String customId) {
        BankLogin bankLogin = this.bankLoginRepository.findById(bankLoginID, customId);
        return bankLogin != null && !"0".equals(bankLogin.getEnable());
    }

    private String checkDatacenter(String name) {
        if (SystemPropertyConfig.isDatacenterCheckOpen()) {
            List datacenterList = SystemPropertyConfig.getDatacenterList();
            if (Objects.nonNull(datacenterList) && !datacenterList.isEmpty()) {
                for (String datacenter : datacenterList) {
                    if (!StrUtil.equals((String)datacenter, (String)name)) continue;
                    return null;
                }
            }
            return String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u63a5\u5165\u7684\u6570\u636e\u4e2d\u5fc3:%s\u3002", (String)"EBServiceHandlerEnhance_16", (String)"ebg-aqap-mservice", (Object[])new Object[0]), name);
        }
        return null;
    }

    private boolean checkQueryDetail(String accNo) {
        List queryDetailAcntList = SystemPropertyConfig.getQueryDetailList();
        if (queryDetailAcntList != null && queryDetailAcntList.size() > 0) {
            return queryDetailAcntList.contains(accNo);
        }
        return true;
    }

    private String checkIp() {
        String loginIP = RequestContext.get().getLoginIP();
        boolean isOpenApi = StringUtils.isNotEmpty((String)RequestContext.get().getApi3rdAppId());
        if (isOpenApi && StringUtils.isNotEmpty((String)loginIP)) {
            log.info("\u8bf7\u6c42\u7684ip\u4e3a :{}", (Object)loginIP);
            boolean matchingMode = SystemPropertyConfig.isMatchingMode();
            List configIpList = SystemPropertyConfig.getConfigIpList();
            String[] ipAddresses = loginIP.split("[,\uff0c]");
            boolean ipMatch = false;
            for (String ipAddr : ipAddresses) {
                ipMatch = this.hasMatchConfig(configIpList, ipAddr = ipAddr.trim());
                if (ipMatch) break;
            }
            if (matchingMode) {
                if (!ipMatch && configIpList.size() > 0) {
                    return String.format(ResManager.loadKDString((String)"%s \u4e0d\u5728\u767d\u540d\u5355\u4e2d\u3002", (String)"EBServiceHandlerEnhance_17", (String)"ebg-aqap-mservice", (Object[])new Object[0]), loginIP);
                }
            } else if (ipMatch && configIpList.size() > 0) {
                return String.format(ResManager.loadKDString((String)"%s \u5728\u9ed1\u540d\u5355\u4e2d\u3002", (String)"EBServiceHandlerEnhance_18", (String)"ebg-aqap-mservice", (Object[])new Object[0]), loginIP);
            }
        }
        return "";
    }

    private boolean hasMatchConfig(List<String> configIpList, String ipAddr) {
        for (String allowdIp : configIpList) {
            if (!StrUtil.isNotBlank((CharSequence)(allowdIp = StrUtil.trim((CharSequence)allowdIp)))) continue;
            if (allowdIp.contains("*")) {
                Pattern pattern = Pattern.compile(allowdIp);
                boolean matches = pattern.matcher(ipAddr).matches();
                if (!matches) continue;
                return true;
            }
            if (allowdIp.contains("-")) {
                List allowdIpSplit = StrUtil.split((String)allowdIp, (char)'.');
                List ipAddrSplit = StrUtil.split((String)ipAddr, (char)'.');
                if (Objects.nonNull(allowdIp) && Objects.nonNull(ipAddr) && !allowdIpSplit.isEmpty() && !ipAddrSplit.isEmpty() && allowdIpSplit.size() == ipAddrSplit.size()) {
                    for (int i = 0; i < allowdIpSplit.size(); ++i) {
                        String ipSplit;
                        String configSplit = (String)allowdIpSplit.get(i);
                        if (configSplit.equalsIgnoreCase(ipSplit = (String)ipAddrSplit.get(i))) continue;
                        if (configSplit.contains("-")) {
                            List ipRanges = StrUtil.split((String)configSplit, (char)'-');
                            if (ipRanges.size() != 2) {
                                return false;
                            }
                            int start = Integer.parseInt(StrUtil.trim((CharSequence)((CharSequence)ipRanges.get(0))));
                            int end = Integer.parseInt(StrUtil.trim((CharSequence)((CharSequence)ipRanges.get(1))));
                            int real = Integer.parseInt(ipSplit);
                            return real >= start && real <= end;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (!allowdIp.equalsIgnoreCase(ipAddr)) continue;
            return true;
        }
        return false;
    }
}

