/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.ecny.service.balance;

import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TodayBalanceSubImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final Logger logger = LoggerFactory.getLogger(TodayBalanceSubImpl.class);

    public String pack(BankBalanceRequest request) {
        return this.packNormalTodayBalanceSub(request);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        return this.parseNormalTodayBalanceSub(request, responseStr);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CMRB08";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b50\u94b1\u5305\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceSubImpl_0", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]);
    }

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public String packNormalTodayBalanceSub(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CMRB08", (String)Sequence.genSequence());
        Element Dcep = JDomUtils.addChild((Element)root, (String)"Dcep");
        JDomUtils.addChild((Element)Dcep, (String)"subWalletId", (String)acnt.getAccNo());
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    public EBBankBalanceResponse parseNormalTodayBalanceSub(BankBalanceRequest rqst, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root((String)rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader((Element)root);
        ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u6570\u5b57\u4eba\u6c11\u5e01\u4f59\u989d\u67e5\u8be2\u3002", (String)"TodayBalanceSubImpl_1", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (BankResponse)rsp, (String)"0000");
        Element Dcep = root.getChild("Dcep");
        String balanceStr = ParserUtils.checkUnNullableElement((Element)Dcep, (String)"balAmt");
        BalanceInfo balance = new BalanceInfo();
        logger.info("\u89e3\u6790\u5230\u519c\u884c\u8fd4\u56de\u7684'\u5f53\u524d\u4f59\u989d'\u4e3a{}\u5143", (Object)balanceStr);
        this.setCurrentBalance(balance, balanceStr.trim());
        this.setAvailableBalance(balance, balanceStr.trim());
        this.setBankAcnt(balance, rqst.getAcnt());
        this.setBankCurrency(balance, rqst.getBankCurrency());
        this.setBalanceDateTime(balance, LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public boolean match(BankBalanceRequest request) {
        return "WT10".equals(request.getAcnt().getAccEcnyType());
    }
}

