/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.ecny.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.ecny.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public String pack(BankDetailRequest request) {
        return this.packDetail(request);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        List<DetailInfo> detailInfos = this.parseDetail(request.getAcnt(), responseStr);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage(1);
        boolean lastPage = false;
        this.setLastPage(lastPage);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(request);
            if (Objects.nonNull(response) && Objects.nonNull(response.getDetails())) {
                detailInfos.addAll(response.getDetails());
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CMRB24";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94b1\u5305\u660e\u7ec6\u67e5\u8be2", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]);
    }

    private String packDetail(BankDetailRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        LocalDate startDate = rqst.getStartDate();
        LocalDate endDate = rqst.getEndDate();
        Element root = ABC_DC_Packer.createABCRoot4New((String)"CMRB24", (String)Sequence.genSequence());
        Element corp = JDomUtils.addChild((Element)root, (String)"Dcep");
        JDomUtils.addChild((Element)corp, (String)"walletId", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)corp, (String)"startDate", (String)startDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)corp, (String)"endDate", (String)endDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)corp, (String)"recordPage", (String)(this.getCurrentPage() + ""));
        JDomUtils.addChild((Element)corp, (String)"rowNum", (String)"20");
        JDomUtils.addChild((Element)corp, (String)"traceType", (String)"TR00");
        return ABC_DC_Packer.covert2ABCMessage((Element)root);
    }

    private List<DetailInfo> parseDetail(BankAcnt acnt, String rspStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = ABC_DC_Parser.parseString2Root((String)rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader((Element)root);
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (PropertiesConstants.getValue((String)"ABC_NOT_RECORD").equals(RespInfo)) {
            this.setLastPage(true);
            return detailList;
        }
        if (!"0000".equals(rsp.getResponseCode())) {
            this.setLastPage(true);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s %2$s", (String)"TodayDetailImpl_2", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element Dcep = root.getChild("Dcep");
        String remainNum = Dcep.getChildText("remainNum");
        if (StringUtils.isEmpty((String)remainNum)) {
            this.setLastPage(true);
        } else {
            int remain = Integer.parseInt(remainNum);
            if (remain <= 0) {
                this.setLastPage(true);
            }
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            this.setLastPage(true);
            return detailList;
        }
        String[] splits = new String[]{};
        Element cmp = root.getChild("Cmp");
        String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        splits = ResponseFileUtils.getDetailRspRecords((String)fileName, (String)Sequence.genSequence());
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = 0; i < recordNum; ++i) {
            String accNo = splits[fieldNum * i + 0];
            String dateStr = splits[fieldNum * i + 1];
            String oppAccNo = splits[fieldNum * i + 2];
            String oppAccName = splits[fieldNum * i + 3];
            String amountStr = splits[fieldNum * i + 4];
            String TrType = splits[fieldNum * i + 5];
            String PostScript = splits[fieldNum * i + 6];
            String status = splits[fieldNum * i + 7];
            String transSeq = splits[fieldNum * i + 8];
            if (!"TS01".equals(status) && !"TS03".equals(status)) continue;
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(acnt.getCurrency());
            BigDecimal amout = null;
            if (!StringUtils.isEmpty((String)amountStr)) {
                BigDecimal orgAmt;
                BigDecimal targetAmt = orgAmt = (amout = new BigDecimal(amountStr.trim().substring(3, amountStr.length())));
                if (amountStr.startsWith("CNY+")) {
                    targetAmt = targetAmt.abs();
                    detail.setCreditAmount(targetAmt);
                    detail.setDebitAmount(new BigDecimal("0.00"));
                } else {
                    targetAmt = targetAmt.abs();
                    detail.setDebitAmount(targetAmt);
                    detail.setCreditAmount(new BigDecimal("0.00"));
                }
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u519c\u884c\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"TodayDetailImpl_3", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]));
            }
            detail.setAccNo(accNo);
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(oppAccName);
            detail.setExplanation(PostScript);
            try {
                LocalDateTime transTime = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                detail.setTransTime(transTime);
                dateStr = dateStr.substring(0, 8);
                LocalDate transDate = LocalDate.parse(dateStr, DateTimeFormatter.BASIC_ISO_DATE);
                detail.setTransDate(transDate);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u4ea4\u6613\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38\uff1a%1$s\u3002", (String)"TodayDetailImpl_4", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), e.getMessage()));
            }
            DetailSysFiled.set((DetailInfo)detail, (String)"TrType", (String)TrType);
            detail.setCurrency("CNY");
            detailList.add(detail);
            JSONObject receiptJson = new JSONObject();
            receiptJson.put("transDate", (Object)dateStr);
            receiptJson.put("amountStr", (Object)amountStr);
            receiptJson.put("transSeq", (Object)transSeq);
            detail.setJsonMap(receiptJson.toJSONString());
        }
        return detailList;
    }

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public boolean match(BankDetailRequest request) {
        return true;
    }
}

