/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpUtil
extends AbstractBankXmlImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HttpUtil.class);

    private static CloseableHttpClient createHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        X509TrustManager x509mgr = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String arg0, SSLSocket arg1) throws IOException {
            }

            public void verify(String arg0, String[] arg1, String[] arg2) throws SSLException {
            }

            public void verify(String arg0, X509Certificate arg1) throws SSLException {
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{x509mgr}, null);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        return httpClientBuilder.build();
    }

    private static HttpEntityEnclosingRequestBase buildRequest(String appId, String sign, String body, String url) throws UnsupportedEncodingException {
        HttpPost httpEntityEnclosingRequestBase = new HttpPost(url);
        httpEntityEnclosingRequestBase.addHeader("Content-Type", "application/json");
        httpEntityEnclosingRequestBase.addHeader("x-aob-appID", appId);
        httpEntityEnclosingRequestBase.addHeader("x-aob-bankID", "WZB");
        httpEntityEnclosingRequestBase.addHeader("x-aob-signature", sign);
        StringEntity stringEntity = new StringEntity(body);
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)stringEntity);
        return httpEntityEnclosingRequestBase;
    }

    public static String execPostOrPut(String sign, String body, String url) {
        String appId = RequestContextUtils.getBankParameterValue((String)"appId");
        CloseableHttpClient client = null;
        HttpEntityEnclosingRequestBase request = null;
        EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
        try {
            String res;
            client = HttpUtil.createHttpClient();
            request = HttpUtil.buildRequest(appId, sign, body, url);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            if (!HttpUtil.checkResponse((HttpResponse)response)) {
                String string = "ebgprocess";
                return string;
            }
            String string = res = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    logger.error("error", (Throwable)e);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static String execPostOrPutForPay(String sign, String body, String url) {
        String appId = RequestContextUtils.getBankParameterValue((String)"appId");
        CloseableHttpClient client = null;
        HttpEntityEnclosingRequestBase request = null;
        EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
        try {
            client = HttpUtil.createHttpClient();
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            request = HttpUtil.buildRequest(appId, sign, body, url);
            try {
                String res;
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                HttpUtil.checkResponse((HttpResponse)response);
                String string = res = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            catch (Exception e) {
                String string;
                block15: {
                    EBContext.getContext().setThrowableAfterSend((Throwable)e);
                    string = null;
                    if (client == null) break block15;
                    try {
                        client.close();
                    }
                    catch (IOException e2) {
                        logger.error("error", (Throwable)e2);
                    }
                }
                return string;
                catch (Exception e3) {
                    throw EBExceiptionUtil.payFailException((String)"send error", (Throwable)e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    logger.error("error", (Throwable)e);
                }
            }
        }
    }

    private static boolean checkResponse(HttpResponse httpResponse) throws Exception {
        StatusLine statusLine = httpResponse.getStatusLine();
        switch (statusLine.getStatusCode()) {
            case 200: 
            case 201: {
                return true;
            }
            case 501: {
                return false;
            }
        }
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)Charset.forName("utf-8"));
        logger.info("responseBody:" + responseBody);
        throw new HttpException(statusLine.getStatusCode() + responseBody);
    }
}

