/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.util;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.SM2;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.SM2KeyPair;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.SM2Util;
import kd.ebg.aqap.banks.wzb.opa.util.sm4.SM4Util;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.pqc.legacy.math.linearalgebra.ByteUtils;

public class SMHelper {
    private static SM2 sm2 = new SM2();

    public static String sign(String src, String priKey) throws IOException {
        ECPoint publicKey = SM2Util.generatePubKeyByPriKey(priKey);
        BigInteger privateKey = new BigInteger(priKey, 16);
        SM2KeyPair sm2KeyPair = new SM2KeyPair(publicKey, privateKey);
        byte[] res = sm2.signWithEncode(src, sm2KeyPair);
        return ByteUtils.toHexString((byte[])res).toUpperCase();
    }

    public static String encrypt(String src, String key, String iv) throws Exception {
        byte[] res = SM4Util.encrypt_Cbc_Padding(ByteUtils.fromHexString((String)key), ByteUtils.fromHexString((String)iv), src.getBytes(Charset.forName("UTF-8")));
        return ByteUtils.toHexString((byte[])res).toUpperCase();
    }

    public static String decrypt(String encryptData, String key, String iv) throws Exception {
        byte[] res = SM4Util.decrypt_Cbc_Padding(ByteUtils.fromHexString((String)key), ByteUtils.fromHexString((String)iv), ByteUtils.fromHexString((String)encryptData));
        return new String(res, Charset.forName("UTF-8"));
    }
}

