/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzb.dc.services.Packer;
import kd.ebg.aqap.banks.lzb.dc.services.Parser;
import kd.ebg.aqap.banks.lzb.dc.services.proxy.FileDownLoad;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        Element root = Packer.buildHead((String)"200110", (String)Sequence.gen16Sequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)Packer.formatDate((LocalDate)request.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)Packer.formatDate((LocalDate)request.getEndDate()));
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)EBContext.getContext().getCharsetName());
        return Packer.buildCommonMsg((String)xmlStr);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        String[] splits;
        EBBankDetailResponse response = new EBBankDetailResponse();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponeCode((Element)root);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0:%1$s\uff0c%2$s\u3002", (String)"DetailImpl_7", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equals(record_num)) {
            response.setDetails(detailList);
            return response;
        }
        if ("1".equals(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            String detailContent = new FileDownLoad().doBiz(file_name);
            splits = StringUtils.split((String)detailContent, (String)"|");
        } else if ("0".equals(file_flag)) {
            String serial_record = body.getChildTextTrim("serial_record");
            splits = StringUtils.split((String)serial_record, (String)"|");
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\u3002\u539f\u56e0\uff1a\u94f6\u884c\u8fd4\u56de\u7684file_flag\u5b57\u6bb5\u4e0d\u6b63\u786e\uff0c\u5bfc\u81f4\u94f6\u4f01\u4e91\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]));
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        for (int i = 0; i < recordNum; ++i) {
            String acno = splits[fieldNum * (i + 1) + 1];
            String cur_code = splits[fieldNum * (i + 1) + 2];
            String tr_acdt = splits[fieldNum * (i + 1) + 3];
            String tr_time = splits[fieldNum * (i + 1) + 4];
            String host_serial_no = splits[fieldNum * (i + 1) + 5];
            String oppAcntNumber = splits[fieldNum * (i + 1) + 7];
            String oppName = splits[fieldNum * (i + 1) + 9];
            String oppBank = splits[fieldNum * (i + 1) + 10];
            String crdr_flag = splits[fieldNum * (i + 1) + 22];
            String amt = splits[fieldNum * (i + 1) + 23];
            String balance = splits[fieldNum * (i + 1) + 24];
            String postscript = splits[fieldNum * (i + 1) + 33];
            String purpose = splits[fieldNum * (i + 1) + 34];
            String reserved1 = splits[fieldNum * (i + 1) + 36];
            String reserved2 = splits[fieldNum * (i + 1) + 37];
            String acname = splits[fieldNum * (i + 1) + 38];
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acno);
            detail.setAccName(acname);
            detail.setOppAccNo(oppAcntNumber);
            detail.setOppAccName(oppName);
            detail.setOppBankName(oppBank);
            detail.setCurrency(cur_code);
            if (!StringUtils.isEmpty((String)host_serial_no)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)host_serial_no);
            }
            try {
                if (StringUtils.isEmpty((String)tr_acdt)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]));
                }
                detail.setTransTime(Packer.parseDateTime((String)(tr_acdt + tr_time)));
                detail.setTransDate(Packer.parseDate((String)tr_acdt));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38.%s", (String)"DetailImpl_8", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            if ("D".equals(crdr_flag.trim())) {
                detail.setDebitAmount(new BigDecimal(amt));
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else if ("C".equals(crdr_flag.trim())) {
                detail.setDebitAmount(new BigDecimal("0.00"));
                detail.setCreditAmount(new BigDecimal(amt));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u6807\u5fd7crdr_flag\u4e3a%s,\u671f\u5f85\u8fd4\u56deC\u6216\u8005D", (String)"DetailImpl_9", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), crdr_flag));
            }
            detail.setExplanation(purpose);
            detail.setBankDetailNo(host_serial_no);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tr_acdt", (Object)tr_acdt);
            jsonObject.put("host_serial_no", (Object)host_serial_no);
            jsonObject.put("postscript", (Object)postscript);
            jsonObject.put("purpose", (Object)purpose);
            jsonObject.put("reserved1", (Object)reserved1);
            jsonObject.put("reserved2", (Object)reserved2);
            String serial_no = splits[fieldNum * (i + 1) + 0];
            jsonObject.put("serial_no", (Object)serial_no);
            detail.setJsonMap(jsonObject.toJSONString());
            String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String jsonStr = jsonObject.toJSONString();
            String receiptNo = MatchRule.getInstance().getReceiptNo(request.getHeader().getAcnt().getAccNo(), transDateStr, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detailList.add(detail);
        }
        response.setDetails(detailList);
        return response;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "200110";
    }

    public String recv(InputStream inputStream) {
        String recv = super.recv(inputStream);
        return recv.substring(12);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_6", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]);
    }
}

