/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzb.dc.services.payment.company;

import java.io.InputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzb.dc.services.Packer;
import kd.ebg.aqap.banks.lzb.dc.services.Parser;
import kd.ebg.aqap.banks.lzb.dc.services.payment.allocation.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "300001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u5916\u652f\u4ed8", (String)"PayImpl_1", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = Packer.buildHead((String)"300001", (String)paymentInfo.getBankBatchSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_type", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"rcv_bank_no", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        String amount = paymentInfo.getAmount().setScale(2, 1).toString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"bank_flag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"urgency_flag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"area_flag", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"bank_kind", (String)"");
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"booking_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"booking_date", (String)"");
        JDomUtils.addChild((Element)body, (String)"booking_time", (String)"");
        JDomUtils.addChild((Element)body, (String)"saverecvinfo_flag", (String)"");
        JDomUtils.addChild((Element)body, (String)"mobiles", (String)paymentInfo.getMobiles());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg((String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return Parser.parserPayXml((BankPayRequest)request, (String)responseStr);
    }

    public String recv(InputStream inputStream) {
        String recv = super.recv(inputStream);
        return recv.substring(12);
    }
}

