/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzb.dc.services.Packer;
import kd.ebg.aqap.banks.lzb.dc.services.Parser;
import kd.ebg.aqap.banks.lzb.dc.services.payment.salary.I200201;
import kd.ebg.aqap.banks.lzb.dc.services.proxy.ProxyUpload;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class I300002
extends AbstractPayImpl
implements IPay {
    public static final String BATCH_FILE_HEADER = "ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|";

    public int getBatchSize() {
        return 5000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return I200201.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead((String)this.getBizCode(), (String)Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        String supplyItem = "0";
        if (UseConvertor.isReim((PaymentInfo)paymentInfo)) {
            supplyItem = "1";
        }
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)supplyItem);
        JDomUtils.addChild((Element)body, (String)"amt", (String)"");
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)"");
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"file_name", (String)(paymentInfo.getBankBatchSeqID() + ".txt"));
        BigDecimal totalAmt = BigDecimal.ZERO;
        StringBuilder fileText = new StringBuilder();
        fileText.append(BATCH_FILE_HEADER);
        fileText.append("\r\n");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
            totalAmt = totalAmt.add(info.getAmount());
            fileText.append(info.getIncomeAccNo()).append("|");
            fileText.append(info.getCurrency()).append("|");
            fileText.append(info.getIncomeAccName()).append("|");
            fileText.append("0").append("|");
            fileText.append(info.getAmount().toPlainString()).append("|");
            fileText.append(info.getExplanation()).append("|");
            if (i == paymentInfos.size() - 1) continue;
            fileText.append("\r\n");
        }
        ProxyUpload proxyUpload = new ProxyUpload(fileText.toString());
        proxyUpload.doBiz(paymentInfo.getBankBatchSeqID() + ".txt");
        body.getChild("amt").setText(totalAmt.toPlainString());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg((String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponeCode((Element)root);
        Element head = root.getChild("head");
        String serialNo = head.getChildTextTrim("serial_no");
        if (StringUtils.isEmpty((String)serialNo)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u672a\u8fd4\u56de\u6d41\u6c34\u53f7\u3002", (String)"I300002_1", (String)"ebg-aqap-banks-lzb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            for (PaymentInfo paymentInfo : paymentInfos) {
                paymentInfo.setBankRefID(serialNo);
            }
            if ("0_0000".equals(rsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300002";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

