/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.curandfixed.notice2cur;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CreateNottiImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    public int getBatchSize() {
        return 0;
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT09", curAndFixedInfo.getDetailSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(curAndFixedInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)curAndFixedInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"BankNo", (String)curAndFixedInfo.getFixedAcntBankNo());
        JDomUtils.addChild((Element)root, (String)"Amt", (String)curAndFixedInfo.getAmount());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"NtcDat", (String)"");
        JDomUtils.addChild((Element)corp, (String)"OpCod", (String)"1");
        JDomUtils.addChild((Element)corp, (String)"VoucherType", (String)"");
        JDomUtils.addChild((Element)corp, (String)"VoucherBat", (String)"");
        JDomUtils.addChild((Element)corp, (String)"VoucherNo", (String)"");
        String ntEndDate = curAndFixedInfo.getNtEndDate();
        if (StringUtils.isEmpty((String)ntEndDate)) {
            if ("01".equals(curAndFixedInfo.getInftyp())) {
                JDomUtils.addChild((Element)corp, (String)"EndDate", (String)LocalDate.now().plusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            } else {
                JDomUtils.addChild((Element)corp, (String)"EndDate", (String)LocalDate.now().plusDays(7L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            }
        } else {
            JDomUtils.addChild((Element)corp, (String)"EndDate", (String)ntEndDate);
        }
        JDomUtils.addChild((Element)corp, (String)"ActSeq", (String)curAndFixedInfo.getReqNbrWithoutTag());
        JDomUtils.addChild((Element)corp, (String)"NtcNo", (String)"");
        JDomUtils.addChild((Element)corp, (String)"ActInf", (String)"0");
        JDomUtils.addChild((Element)corp, (String)"PrdSeq", (String)curAndFixedInfo.getReqNbrWithoutTag());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = ABC_DC_Parser.parseString2Root(s);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (StrUtil.isEmpty((String)rsp.getResponseCode())) {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u4e0d\u5b58\u5728RespCode\u8282\u70b9\u6216\u8be5\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"CreateNottiImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            ebBankCurAndFixedResponse.setDetails(cafInfos);
            return ebBankCurAndFixedResponse;
        }
        String respSource = root.getChildTextTrim("RespSource");
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)ResManager.loadKDString((String)"\u519c\u884c\u5df2\u53d7\u7406", (String)"CreateNottiImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)"", (String)"");
            Element corp = root.getChild("Corp");
            String NoticeId = corp.getChildTextTrim("NtcNo");
            curAndFixedInfo.setNotifyId(NoticeId);
        } else if ("5".equalsIgnoreCase(respSource)) {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.FAIL, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u3002", (String)"CreateNottiImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRT09";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u77e5\u5efa\u7acb", (String)"CreateNottiImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }
}

