/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.BCConvert;
import kd.ebg.aqap.banks.abc.dc.service.detail.TodayDetailImpl;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class CQRA18DetailImpl
extends TodayDetailImpl {
    @Override
    public boolean match(BankDetailRequest request) {
        return "CQRA18".equalsIgnoreCase(BankBusinessConfig.getDetailChoose());
    }

    @Override
    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        List<DetailInfo> detailInfos = this.parseCQRA18Detail(responseStr);
        for (DetailInfo detailInfo : detailInfos) {
            detailInfo.setAccNo(request.getAcnt().getAccNo());
            detailInfo.setBankName(request.getAcnt().getBankName());
            detailInfo.setAccName(request.getAcnt().getAccName());
        }
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> parseCQRA18Detail(String rspStr) {
        String[] splits;
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (PropertiesConstants.getValue((String)"NOT_RECORD").equalsIgnoreCase(RespInfo)) {
            return detailList;
        }
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s %2$s", (String)"TodayDetailImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return detailList;
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        Element cmp = root.getChild("Cmp");
        if ("1".equalsIgnoreCase(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getDetailRspRecords((String)fileName, (String)"");
        } else {
            String respPrvData = ParserUtils.checkUnNullableElement((Element)cmp, (String)"RespPrvData");
            splits = StringUtils.split((String)respPrvData, (String)"|");
        }
        int fieldNum = Integer.parseInt(fieldNumStr);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        JSONObject receiptJson = new JSONObject();
        for (int i = 0; i < recordNum; ++i) {
            BigDecimal orgAmt;
            receiptJson.clear();
            String accNo = splits[fieldNum * i + 1];
            String currency = splits[fieldNum * i + 2];
            String dateStr = splits[fieldNum * i + 3];
            String timeStr = splits[fieldNum * i + 4];
            String detailNo = splits[fieldNum * i + 5];
            String TrType = splits[fieldNum * i + 7];
            String trFrom = splits[fieldNum * i + 8];
            String flag = splits[fieldNum * i + 10];
            String oppDbProv = splits[fieldNum * i + 11];
            String oppAccNo = splits[fieldNum * i + 12];
            String oppAccName = splits[fieldNum * i + 14];
            String oppAccBank = splits[fieldNum * i + 15];
            oppAccBank = this.checkUnicodeString(oppAccBank);
            if (ABC_DC_Parser.is17Lehgth()) {
                oppAccNo = (oppDbProv + oppAccNo).trim();
            }
            String logAccNo = splits[fieldNum * i + 16];
            String logAccName = splits[fieldNum * i + 17];
            String amountStr = splits[fieldNum * i + 21];
            String balanceStr = splits[fieldNum * i + 22];
            String CustRef = splits[fieldNum * i + 29];
            String Abs = splits[fieldNum * i + 33];
            String PostScript = splits[fieldNum * i + 34];
            PostScript = this.checkUnicodeString(PostScript);
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(currency);
            BigDecimal amout = null;
            if (StrUtil.isEmpty((String)amountStr)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u519c\u884c\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"TodayDetailImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            }
            amout = new BigDecimal(amountStr.trim());
            BigDecimal targetAmt = orgAmt = amout;
            if ("1".equalsIgnoreCase(flag) || "4".equalsIgnoreCase(flag)) {
                targetAmt = targetAmt.abs();
                targetAmt = targetAmt.multiply(new BigDecimal("-1"));
            } else {
                targetAmt = targetAmt.abs();
            }
            if (orgAmt.signum() < 0) {
                detail.setDebitAmount(targetAmt);
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else {
                detail.setCreditAmount(targetAmt);
                detail.setDebitAmount(new BigDecimal("0.00"));
            }
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(oppAccName);
            detail.setOppBankName(oppAccBank);
            detail.setFrmcod(logAccNo);
            boolean isEBGSubmit = false;
            String PostScriptHalf = BCConvert.qj2bj((String)PostScript);
            if (CustRef.indexOf("KD_") != -1) {
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)CustRef);
                detail.setPayBankDetailSeqID(CustRef);
                isEBGSubmit = true;
            } else if (PostScriptHalf.indexOf("_KD_") != -1) {
                String batchNO = PostScriptHalf.substring(0, PostScriptHalf.indexOf("_KD_"));
                PostScriptHalf = PostScriptHalf.substring(batchNO.length() + "_KD_".length());
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)batchNO);
                detail.setPayBankDetailSeqID(batchNO);
                isEBGSubmit = true;
            }
            Map<String, String> bankChargeConfig = BankBusinessConfig.getBankChargeConfig();
            String trFromCn = bankChargeConfig.get(trFrom);
            boolean bankChargeFlag = false;
            if (trFromCn != null) {
                bankChargeFlag = true;
                PostScriptHalf = StrUtil.join((String)";", (String)PostScriptHalf, (String)trFromCn);
            }
            detail.setSortField(timeStr);
            detail.setExplanation(PostScriptHalf);
            detail.setUseCN(TrType);
            if (!isEBGSubmit && CQRA18DetailImpl.isTransUp(Abs)) {
                detail.setTransType("autotransup");
            } else if (!isEBGSubmit && CQRA18DetailImpl.isTransDown(Abs)) {
                detail.setTransType("autotransdown");
            } else if (bankChargeFlag) {
                detail.setTransType("bankcharge");
            }
            try {
                LocalDateTime transTime = LocalDateTime.parse(timeStr.substring(0, 14), DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                detail.setTransTime(transTime);
                LocalDate transDate = LocalDate.parse(dateStr, DateTimeFormatter.BASIC_ISO_DATE);
                detail.setTransDate(transDate);
            }
            catch (DateTimeParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u4ea4\u6613\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38\u3002", (String)"TodayDetailImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
            }
            if (!StrUtil.isEmpty((String)balanceStr)) {
                detail.setBalance(new BigDecimal(balanceStr.trim()));
            }
            String fixedAccNo = AcntNumberHelper.fixAccNoTo15Or19(accNo);
            String fixedDateStr = timeStr.substring(0, 8);
            StringBuilder sBuffer = new StringBuilder();
            receiptJson.put("accNo", (Object)fixedAccNo);
            receiptJson.put("transDate", (Object)fixedDateStr);
            receiptJson.put("serialNo", (Object)detailNo);
            receiptJson.put("CustRef", (Object)CustRef);
            receiptJson.put("TimeStab", (Object)timeStr);
            receiptJson.put("TrJrn", (Object)detailNo);
            receiptJson.put("abstract", (Object)Abs);
            receiptJson.put("postscript", (Object)PostScript);
            if (BankBusinessConfig.isPushedFromMaster()) {
                if (StrUtil.isEmpty((String)oppAccNo)) {
                    oppAccNo = "0";
                    receiptJson.put("oppAccNo", (Object)"e");
                } else {
                    oppAccNo = AcntNumberHelper.fixAccNoTo15Or19(oppAccNo);
                    receiptJson.put("oppAccNo", (Object)oppAccNo);
                }
                receiptJson.put("Amount", (Object)targetAmt);
                sBuffer.append(fixedAccNo).append('-').append(fixedDateStr).append('-').append(detailNo).append('-').append(oppAccNo).append('-').append(targetAmt.abs());
            } else {
                sBuffer.append(fixedAccNo).append('-').append(fixedDateStr).append('-').append(detailNo);
            }
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, fixedDateStr, receiptJson.toJSONString());
            detail.setJsonMap(receiptJson.toJSONString());
            Integer value = (Integer)countMap.get(receiptNo);
            if (value != null) {
                int count = value + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(detailNo);
            if ("HRMS".equalsIgnoreCase(trFrom)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"VouhNo", (String)PostScript);
            }
            StringBuilder bizNoBuffer = new StringBuilder();
            bizNoBuffer.append(dateStr).append(detailNo);
            DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)bizNoBuffer.toString());
            detailList.add(detail);
        }
        return detailList;
    }

    private static boolean isTransUp(String abs) {
        return "1023".equals(abs) || "1025".equals(abs) || "1022".equals(abs) || "1055".equals(abs);
    }

    private static boolean isTransDown(String abs) {
        return "1024".equals(abs) || "1026".equals(abs) || "1021".equals(abs) || "1056".equals(abs);
    }

    private String checkUnicodeString(String value) {
        char[] xmlChar = value.toCharArray();
        for (int i = 0; i < xmlChar.length; ++i) {
            if (xmlChar[i] > '\ufffd') {
                xmlChar[i] = 32;
                continue;
            }
            if (xmlChar[i] >= ' ' || xmlChar[i] == 't' || xmlChar[i] == 'n' || xmlChar[i] == 'r') continue;
            xmlChar[i] = 32;
        }
        return new String(xmlChar);
    }

    @Override
    public String getBizCode() {
        return "CQRA18";
    }

    @Override
    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u8d26\u6237\u660e\u7ec6\uff08\u542b\u8d26\u7c3f\u53f7\uff09 \uff08CQRA18\uff09 \u4ea4\u6613", (String)"CQRA18DetailImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }
}

