/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryHelper;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.jdom2.Element;

public class SalaryParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(SalaryParser.class);

    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) {
        if (null == rspStr) {
            this.setSalaryState(paymentInfos, PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u63a5\u6536\u94f6\u884c\u54cd\u5e94\u5f02\u5e38\u3002", (String)"SalaryParser_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), "", "");
            return;
        }
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            this.setSalaryState(paymentInfos, PaymentState.SUBMITED, ResManager.loadKDString((String)"\u519c\u884c\u5df2\u63a5\u6536", (String)"SalaryParser_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), "", "");
        } else {
            this.setSalaryState(paymentInfos, PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u519c\u884c\u63a5\u6536\u5f02\u5e38", (String)"SalaryParser_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
        }
    }

    private void setSalaryState(PaymentInfo[] paymentInfos, PaymentState paymentstate, String statusMsg, String bankStatus, String bankMsg) {
        for (int i = 0; i < paymentInfos.length; ++i) {
            paymentInfos[i].setStatus(Integer.valueOf(paymentstate.getId()));
            paymentInfos[i].setStatusName(paymentstate.getEnName());
            paymentInfos[i].setStatusMsg(statusMsg);
            paymentInfos[i].setBankStatus(bankStatus);
            paymentInfos[i].setBankMsg(bankMsg);
        }
    }

    public String parseSalaryTranResultRsp(PaymentInfo paymentInfo, String recvMsg, String bizSeqId) {
        Element root = ABC_DC_Parser.parseString2Root(recvMsg);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            Element cmp = root.getChild("Cmp");
            String fileFlag = ParserUtils.checkUnNullableElement((Element)cmp, (String)"FileFlag");
            if (!"1".equalsIgnoreCase(fileFlag)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613\u7ed3\u679c\u8fd4\u56de\u6587\u4ef6\u6807\u8bc6:%1$s\u3002", (String)"SalaryParser_21", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), fileFlag));
            }
            String data = ResManager.loadKDString((String)"\u6d41\u6c34\u53f7|\u4e2d\u95f4\u4e1a\u52a1\u6d41\u6c34\u53f7|\u4f01\u4e1a\u4ee3\u7801|94\u884c\u53f7|94\u8d26\u53f7|\u7533\u8bf7\u603b\u91d1\u989d|\u7533\u8bf7\u603b\u7b14\u6570|\u7533\u8bf7\u5f00\u59cb\u65e5\u671f|\u7533\u8bf7\u7ed3\u675f\u65e5\u671f|\u5f55\u5165\u65e5\u671f|\u5904\u7406\u72b6\u6001|\u4e3b\u673a\u5904\u7406\u72b6\u6001|\u6210\u529f\u603b\u91d1\u989d|\u6210\u529f\u603b\u7b14\u6570|\u4e3b\u673a\u8fd4\u56de\u7801|\u63cf\u8ff0|\u72b6\u6001|\u53d1\u9001\u7684\u6587\u4ef6\u540d|\u8fd4\u56de\u5904\u7406\u7ed3\u679c\u6587\u4ef6|\u5907\u6ce8|\u4e1a\u52a1\u6807\u5fd7|", (String)"SalaryParser_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
            int fieldsLength = SalaryHelper.getSepCount((String)data, (int)124);
            String batchFileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            String[] splits = ResponseFileUtils.getDetailRspRecords((String)batchFileName, (String)bizSeqId);
            String salaryFileName = SalaryHelper.getSalaryFileName((String)paymentInfo.getBankDetailSeqId());
            int rowCount = splits.length / fieldsLength;
            for (int i = 1; i < rowCount; ++i) {
                String state = splits[fieldsLength * i + 16];
                String retSendFile = splits[fieldsLength * i + 17];
                if (salaryFileName.equalsIgnoreCase(retSendFile)) {
                    if ("0".equalsIgnoreCase(state)) {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                        paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u4e3b\u673a\u5904\u7406\u60c5\u51b5\u672a\u77e5\uff0c\u9700\u8981\u7ee7\u7eed\u67e5\u8be2\u3002", (String)"SalaryParser_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                    } else if ("1".equalsIgnoreCase(state)) {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.FAIL.getId()));
                        paymentInfo.setStatusName(PaymentState.FAIL.getEnName());
                        paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u4e2d\u95f4\u4e1a\u52a1\u5904\u7406\u5931\u8d25\u3002", (String)"SalaryParser_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                    } else if ("8".equalsIgnoreCase(state)) {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                        paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u8d26\u52a1\u5df2\u5904\u7406,\u4f46\u6ca1\u6709\u53d6\u5230\u7ed3\u679c\u6587\u4ef6,\u8bf7\u81f4\u7535\u519c\u884c\u76f8\u5173\u4eba\u5458\u8fdb\u884c\u89e3\u51b3!", (String)"SalaryParser_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                    } else if ("9".equalsIgnoreCase(state)) {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                        paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"SalaryParser_8", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                    } else if ("2".equalsIgnoreCase(state)) {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                        paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f\uff0c\u7ed3\u679c\u6587\u4ef6\u53ef\u53d6\u3002", (String)"SalaryParser_9", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                    } else {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                        paymentInfo.setStatusMsg(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5\u67e5\u8be2\u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613\u7ed3\u679c\u72b6\u6001:%1$s\u3002", (String)"SalaryParser_22", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), state));
                    }
                    return splits[fieldsLength * i + 0];
                }
                this.log.info("\u94f6\u884c\u8fd4\u56de\u53d1\u9001\u6587\u4ef6\u540d(" + retSendFile + ")\u548c\u4ed8\u6b3e\u53d1\u9001\u6587\u4ef6\u540d\u4e0d\u540c(" + salaryFileName + ")");
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u80fd\u67e5\u8be2\u5230\u8be5\u7b14\u6d41\u6c34%1$s\u5bf9\u5e94\u7684ICS\u6d41\u6c34\u53f7\u3002", (String)"SalaryParser_23", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), paymentInfo.getBankDetailSeqId()));
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613\u7ed3\u679c\u5f02\u5e38:%1$s\u3002", (String)"SalaryParser_24", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode() + "," + rsp.getResponseMessage()));
    }

    public void parseMidBizDetailResultRsp(PaymentInfo paymentInfo, String recvMsg, String bizSeqId) {
        Element root = ABC_DC_Parser.parseString2Root(recvMsg);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            Element cmp = root.getChild("Cmp");
            String batchFileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            String[] splits = ResponseFileUtils.getDetailRspRecords((String)batchFileName, (String)bizSeqId);
            String data = ResManager.loadKDString((String)"\u5e8f\u53f7|\u72b6\u6001|\u8d26\u53f7|\u6237\u540d|\u91d1\u989d|\u5907\u6ce8|\u9519\u8bef\u4fe1\u606f|\u3002", (String)"SalaryParser_14", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
            int fieldsLength = SalaryHelper.getSepCount((String)data, (int)124);
            int rowCount = splits.length / fieldsLength;
            if (fieldsLength > 0) {
                for (int i = 1; i < rowCount; ++i) {
                    String state = splits[fieldsLength * i + 1];
                    String retOppAccNo = splits[fieldsLength * i + 2];
                    String retAmtStr = splits[fieldsLength * i + 4];
                    BigDecimal retAmt = new BigDecimal(retAmtStr);
                    String errMsg = splits[fieldsLength * i + 6];
                    String sendOppAccNo = SalaryHelper.getOppAcntnumber((String)paymentInfo.getBankDetailSeqId());
                    String sendAmtStr = SalaryHelper.getOppAmt((String)paymentInfo.getBankDetailSeqId());
                    BigDecimal sendAmt = new BigDecimal(sendAmtStr);
                    if (!sendOppAccNo.equalsIgnoreCase(retOppAccNo) || sendAmt.compareTo(retAmt) != 0) continue;
                    errMsg = !StrUtil.isEmpty((String)errMsg) ? String.format(ResManager.loadKDString((String)".\u9519\u8bef\u4fe1\u606f:%1$s\u3002", (String)"SalaryParser_29", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), errMsg) : "";
                    if ("E".equalsIgnoreCase(state)) {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.FAIL.getId()));
                        paymentInfo.setStatusName(PaymentState.FAIL.getEnName());
                        paymentInfo.setStatusMsg(String.format(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25%1$s\u3002", (String)"SalaryParser_25", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), errMsg));
                        continue;
                    }
                    if ("P".equalsIgnoreCase(state)) {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                        paymentInfo.setStatusMsg(String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5904\u7406%1$s\u3002", (String)"SalaryParser_26", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), errMsg));
                        continue;
                    }
                    if ("S".equalsIgnoreCase(state)) {
                        paymentInfo.setStatus(Integer.valueOf(PaymentState.SUCCESS.getId()));
                        paymentInfo.setStatusName(PaymentState.SUCCESS.getEnName());
                        paymentInfo.setStatusMsg("");
                        continue;
                    }
                    paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                    paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                    paymentInfo.setStatusMsg(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5\u67e5\u8be2\u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613\u7ed3\u679c\u72b6\u6001:%1$s\u3002", (String)"SalaryParser_22", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), state));
                }
            } else {
                paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u7ed3\u679c\u6587\u4ef6\u4e2d\u8bb0\u5f55\u6570\u4e3a\u7a7a\u3002", (String)"SalaryParser_18", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e2d\u95f4\u4e1a\u52a1\u660e\u7ec6\u5904\u7406\u7ed3\u679c\u5f02\u5e38,\u5bf9\u5e94\u6d41\u6c34\u53f7:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"SalaryParser_27", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), paymentInfo.getBankDetailSeqId()), (String)(rsp.getResponseCode() + "," + rsp.getResponseMessage()));
        }
    }
}

