/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.oversea;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.acctype.AccTypeEnum;
import kd.ebg.aqap.banks.abc.dc.service.payment.oversea.GQLT28QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class GFRB15PayImpl
extends AbstractPayImpl
implements IPay {
    private static final Map<String, String> FeeTypeMap = new HashMap<String, String>(3);
    private static final Map<String, String> NormalFeeTypeMap = new HashMap<String, String>(2);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return GQLT28QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = ABC_DC_Packer.createABCRoot4New(this.getBizCode(), paymentInfo.getBankDetailSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        if (paymentInfo.getAccNo().startsWith(AccTypeEnum.FTE.getType()) || paymentInfo.getAccNo().startsWith(AccTypeEnum.FTN.getType())) {
            JDomUtils.addChild((Element)cmp, (String)"DbAccType", (String)AccTypeEnum.getAccNoType((String)paymentInfo.getAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)paymentInfo.getAccNo().substring(3, 5));
        } else {
            JDomUtils.addChild((Element)cmp, (String)"DbAccType", (String)"");
            JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        }
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15(paymentInfo.getAccNo()));
        if (paymentInfo.getIncomeAccNo().startsWith(AccTypeEnum.FTE.getType()) || paymentInfo.getIncomeAccNo().startsWith(AccTypeEnum.FTN.getType()) || paymentInfo.getIncomeAccNo().startsWith(AccTypeEnum.NRA.getType())) {
            JDomUtils.addChild((Element)cmp, (String)"CrAccType", (String)AccTypeEnum.getAccNoType((String)paymentInfo.getIncomeAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)paymentInfo.getIncomeAccNo().substring(3, 5));
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)AcntNumberHelper.fixAccNoTo15(paymentInfo.getIncomeAccNo()));
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrAccType", (String)"");
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)paymentInfo.getIncomeAccNo());
        }
        String amout = paymentInfo.getAmount().setScale(2, 4).toString();
        Element biz = JDomUtils.addChild((Element)root, (String)"Biz");
        JDomUtils.addChild((Element)biz, (String)"Amt", (String)amout);
        JDomUtils.addChild((Element)biz, (String)"PayName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)biz, (String)"PayAddr", (String)paymentInfo.getPayerAddress());
        JDomUtils.addChild((Element)biz, (String)"RecvName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)biz, (String)"RecvAddr", (String)paymentInfo.getIncomeAddress());
        JDomUtils.addChild((Element)biz, (String)"RecvBkSC", (String)paymentInfo.getIncomeSwiftCode());
        JDomUtils.addChild((Element)biz, (String)"RecvBkName", (String)paymentInfo.getIncomeBankName());
        String feeType = paymentInfo.getPayerFeeType();
        if (this.isNormalAccForAbc(paymentInfo)) {
            if ("03".equals(feeType)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u666e\u901a\u8d26\u53f7\uff08\u519c\u884c\uff09\u4e0d\u652f\u6301\u5171\u540c\u627f\u62c5\u8d39\u7528", (String)"GFRB15PayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)biz, (String)"FeeBear", (String)NormalFeeTypeMap.get(feeType));
        } else {
            JDomUtils.addChild((Element)biz, (String)"FeeBear", (String)FeeTypeMap.get(feeType));
        }
        JDomUtils.addChild((Element)biz, (String)"ApplName", (String)paymentInfo.getApplyName());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element bizElement = root.getChild("Biz");
        String seqNo = bizElement.getChildText("SeqNo");
        String seqType = bizElement.getChildText("SeqType");
        ((PaymentInfo)paymentInfos.get(0)).setBiz("seqNo", seqNo);
        ((PaymentInfo)paymentInfos.get(0)).setBiz("seqType", seqType);
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GFRB15";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"FT\u8d26\u6237\u4eba\u6c11\u5e01\u6c47\u6b3e", (String)"GFRB15PayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    private boolean isNormalAccForAbc(PaymentInfo paymentInfo) {
        if (!paymentInfo.is2SameBank()) {
            return false;
        }
        String incomeAccNo = paymentInfo.getIncomeAccNo();
        return !incomeAccNo.startsWith("FTE") && !incomeAccNo.startsWith("FTN") && !incomeAccNo.startsWith("NRA");
    }

    private String getBankAccType(String accNo) {
        if (accNo.startsWith("FTE")) {
            return "FTE";
        }
        if (accNo.startsWith("FTN")) {
            return "FTN";
        }
        if (accNo.startsWith("NRA")) {
            return "NRA";
        }
        return "";
    }

    static {
        FeeTypeMap.put("01", "DEBT");
        FeeTypeMap.put("02", "CRED");
        FeeTypeMap.put("03", "SHAR");
        NormalFeeTypeMap.put("02", "2");
        NormalFeeTypeMap.put("01", "1");
    }
}

