/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch;

import java.io.IOException;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABCErrCodeDataBase;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.BytesReader;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ABC_DCFileParser {
    public static void parseQueryWagePaymentStateMessageInFile(String fileContent, String orgReqSeqNo, PaymentInfo[] paymentInfos) {
        String[] lines = null;
        try {
            lines = StringUtils.split2Lines((String)fileContent);
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u519c\u884c\u6587\u4ef6\u51fa\u9519\uff0c\u8bfb\u53d6\u884c\u5931\u8d25\u3002", (String)"ABC_DCFileParser_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
        }
        if (lines.length < 2) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6279\u91cf\u4ee3\u53d1\u6587\u4ef6\u4e2d\u6ca1\u6709\u660e\u7ec6\u6570\u636e   ", (String)"ABC_DCFileParser_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        for (int i = 1; i < lines.length; ++i) {
            ABC_DCFileParser.parseEachLine(lines[i], paymentInfos);
        }
    }

    private static void parseEachLine(String line, PaymentInfo[] paymentInfos) {
        BytesReader reader = new BytesReader(line, RequestContextUtils.getCharset());
        reader.read(24);
        reader.read(70);
        String incomeAccNo = reader.read(32);
        reader.read(1);
        String amountStr = reader.read(19);
        reader.read(2);
        reader.read(70);
        reader.read(8);
        if (StringUtils.isEmpty((String)amountStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"ABC_DCFileParser_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        BigDecimal amount = ParserUtils.convertCentStr2Yuan((String)amountStr.trim());
        PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)incomeAccNo, (BigDecimal)amount);
        if (null == paymentInfo) {
            return;
        }
        String result = reader.read(4);
        if (StringUtils.isEmpty((String)result)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8bb0\u8d26\u7ed3\u679c\u4e3a\u7a7a\uff0c\u72b6\u6001\u53ef\u7591\uff0c\u8bf7\u54a8\u8be2\u519c\u884c\u3002", (String)"ABC_DCFileParser_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)result, (String)"");
        } else if ("0000".equals(result.trim())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)result, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"ABC_DCFileParser_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        } else {
            String bankMsg = ABCErrCodeDataBase.getValue((String)result.trim());
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)result, (String)bankMsg);
        }
    }
}

