/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.dc.services.FixedHelper;
import kd.ebg.aqap.banks.citic.dc.services.ParserProxy;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FixedBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(FixedBalanceImpl.class);
    private String endDateKey = "endDateStr";

    public boolean isSupportPage(BankBalanceRequest request) {
        return true;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        this.doBizWithPagePre(request);
        EBBankBalanceResponse response = this.doBizWithPage(request);
        List balanceInfos = response.getBalances();
        BigDecimal currentBalance = BigDecimal.ZERO;
        for (BalanceInfo balanceInfo : balanceInfos) {
            currentBalance = currentBalance.add(balanceInfo.getCurrentBalance());
        }
        BalanceInfo balance = new BalanceInfo();
        balance.setCurrentBalance(currentBalance);
        balance.setBalanceDateTime(LocalDateTime.now());
        balance.setBankAcnt(request.getAcnt());
        balance.setBankCurrency(request.getBankCurrency());
        return response;
    }

    public String pack(BankBalanceRequest request) {
        LocalDate startDate;
        String accNo = request.getAcnt().getAccNo();
        String masterAccNo = BankBusinessConfig.getMasterAccount(accNo);
        String openAccountDate = BankBusinessConfig.getOpenFixAccountDate(accNo);
        if (StringUtils.isEmpty((String)masterAccNo) && !EBContext.getContext().isUnitTest()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5173\u8054\u4e3b\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u7ef4\u62a4\u3002", (String)"FixedBalanceImpl_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)openAccountDate) && !EBContext.getContext().isUnitTest()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u5f00\u6237\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u7ef4\u62a4\u3002", (String)"FixedBalanceImpl_6", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLFNDQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)masterAccNo);
        JDomUtils.addChild((Element)root, (String)"qryFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"openChanl", (String)"0");
        JDomUtils.addChild((Element)root, (String)"qryType", (String)"0");
        if (Objects.equals(this.getCurrentPage(), "0")) {
            startDate = LocalDateUtil.parserDate((String)openAccountDate);
        } else {
            String endDateStr = RequestContextUtils.getRunningParam((String)this.endDateKey);
            startDate = LocalDateUtil.parserDate((String)endDateStr).minusDays(-1L);
        }
        LocalDate endDate = this.getNextDate(startDate);
        JDomUtils.addChild((Element)root, (String)"startDate", (String)LocalDateUtil.formatDate((LocalDate)startDate));
        JDomUtils.addChild((Element)root, (String)"endDate", (String)LocalDateUtil.formatDate((LocalDate)endDate));
        String encoding = RequestContextUtils.getCharset();
        String requestStr = JDomUtils.root2String((Element)root, (String)encoding);
        RequestContextUtils.setRunningParam((String)this.endDateKey, (String)LocalDateUtil.formatDate((LocalDate)endDate));
        return requestStr;
    }

    private LocalDate getNextDate(LocalDate startDate) {
        LocalDate nextYear = startDate.minusYears(-1L);
        if (nextYear.isAfter(LocalDate.now())) {
            return LocalDate.now();
        }
        return nextYear.minusDays(1L);
    }

    public boolean isLastPageOnBalance() {
        String endDateStr = RequestContextUtils.getRunningParam((String)this.endDateKey);
        LocalDate endDate = LocalDateUtil.parserDate((String)endDateStr);
        if (endDate.isBefore(LocalDate.now())) {
            String currentPage = this.getCurrentPage();
            this.setCurrentPage(Integer.toString(Integer.parseInt(currentPage) + 1));
            return false;
        }
        return true;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        this.setLastPage(this.isLastPageOnBalance());
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode((Element)root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element list = JDomUtils.getChildElement((Element)root, (String)"list");
        List rows = list.getChildren("row");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        String currencyID = "";
        BigDecimal currentBalance = BigDecimal.ZERO;
        BalanceInfo balance = new BalanceInfo();
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String fixAccNo = JDomUtils.getChildText((Element)row, (String)"fixAccNo");
            if (!accNo.equalsIgnoreCase(fixAccNo) || !StringUtils.isEmpty((String)(currencyID = JDomUtils.getChildText((Element)row, (String)"cryType"))) && !currencyID.equalsIgnoreCase(request.getBankCurrency())) continue;
            String balanceStr = JDomUtils.getChildText((Element)row, (String)"balance");
            balance = new BalanceInfo();
            this.setCurrentBalance(balance, balanceStr);
            if (StringUtils.isEmpty((String)balance.getError())) {
                BigDecimal bigDecimal = new BigDecimal(balanceStr);
                currentBalance = currentBalance.add(bigDecimal);
                continue;
            }
            log.error(balance.getError());
        }
        balance.setCurrentBalance(currentBalance);
        balance.setBalanceDateTime(LocalDateTime.now());
        balance.setBankAcnt(acnt);
        balance.setBankCurrency(request.getBankCurrency());
        balanceInfos.add(balance);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public boolean match(BankBalanceRequest request) {
        return FixedHelper.isFixedAcnt((String)request.getHeader().getAcnt().getAccNo());
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "DLFNDQRY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4f59\u989d", (String)"FixedBalanceImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }
}

