/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.bocom.dc.service.hk.Utils;
import kd.ebg.aqap.banks.bocom.dc.service.util.Check;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final Logger logger = LoggerFactory.getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        String reqStr = BankBusinessConfig.isSecondaryAccount(request.getAcnt().getAccNo()) ? this.packSecondaryAccountBalance(request) : (BankBusinessConfig.isVcpAcnt(request.getAcnt().getAccNo()) ? this.packAccountPoolBalance(request) : (BankBusinessConfig.isFixedAcnt(request.getAcnt().getAccNo()) ? this.packAccountFixedBalance(request) : (BankBusinessConfig.isCashPoolAcnt(request.getAcnt().getAccNo()) ? this.packAccountCashPoolBalance(request) : (BankBusinessConfig.isOsaAcnt(request.getAcnt().getAccNo()) ? this.packOsaBalance(request) : this.packCommonTodayBalance(request)))));
        return reqStr;
    }

    private String packOsaBalance(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        Element root = BOCOM_DC_Packer.packRoot((String)"310901");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    private String packAccountCashPoolBalance(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        Element root = BOCOM_DC_Packer.packRoot((String)"310107");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"currentType", (String)request.getBankCurrency());
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public String packCommonTodayBalance(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        String accNo = acnt.getAccNo();
        Element root = BOCOM_DC_Packer.packRoot((String)"310101");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public String packAccountPoolBalance(BankBalanceRequest rqst) {
        Element root = BOCOM_DC_Packer.packRoot((String)"310103", (int)1);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)rqst.getAcnt().getAccNo());
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public String packAccountFixedBalance(BankBalanceRequest rqst) {
        Element root = BOCOM_DC_Packer.packRoot((String)"410101", (int)1);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)rqst.getAcnt().getAccNo());
        String reqMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        logger.info("\u67e5\u8be2\u5b9a\u671f\u6237\u4f59\u989d-410101\u63a5\u53e3-\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqMsg);
        return reqMsg;
    }

    public String packSecondaryAccountBalance(BankBalanceRequest rqst) {
        Element root = BOCOM_DC_Packer.packRoot((String)"585046", (int)1);
        String accNo = rqst.getAcnt().getAccNo();
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"man-acno", (String)BankBusinessConfig.getUpAccount(accNo));
        JDomUtils.addChild((Element)body, (String)"mbr-acno", (String)accNo);
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        if (BankBusinessConfig.isVcpAcnt(request.getAcnt().getAccNo()) || BankBusinessConfig.isSecondaryAccount(request.getAcnt().getAccNo()) || BankBusinessConfig.isFixedAcnt(request.getAcnt().getAccNo()) || BankBusinessConfig.isCashPoolAcnt(request.getAcnt().getAccNo())) {
            return this.parseAccountPoolBalance(request, responseStr);
        }
        if (BankBusinessConfig.isOsaAcnt(request.getAcnt().getAccNo())) {
            return this.psrseOsaBalance(request, responseStr);
        }
        return this.parseCommonTodayBalance(request, responseStr);
    }

    private EBBankBalanceResponse psrseOsaBalance(BankBalanceRequest request, String responseStr) {
        String inputBankCurr = request.getBankCurrency();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)root);
        ParserUtils.checkRspCode((BankResponse)rsp, (String)"0000");
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = serial_record.split("\\|");
        ArrayList<BalanceInfo> list = new ArrayList<BalanceInfo>(1);
        for (int i = 1; i <= recordNum; ++i) {
            BalanceInfo balance = new BalanceInfo();
            String accNo = splits[fieldNum * i + 1];
            String currency = splits[fieldNum * i + 2];
            String currentBalance = splits[fieldNum * i + 3];
            String availableBalance = splits[fieldNum * i + 4];
            String rspMsg = splits[fieldNum * i + 5];
            String rspCode = splits[fieldNum * i + 6];
            if (!"0".equalsIgnoreCase(rspCode)) {
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspCode, (String)rspMsg));
            }
            this.setBankAcnt(balance, request.getBankAcntList(), accNo);
            this.setBankCurrency(balance, inputBankCurr, currency);
            this.setCurrentBalance(balance, currentBalance);
            this.setAvailableBalance(balance, availableBalance);
            this.setBalanceDateTime(balance, LocalDateTime.now());
            list.add(balance);
        }
        return new EBBankBalanceResponse(list);
    }

    public EBBankBalanceResponse parseCommonTodayBalance(BankBalanceRequest rqst, String rspStr) {
        String inputBankCurr = rqst.getBankCurrency();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)root);
        ParserUtils.checkRspCode((BankResponse)rsp, (String)"0000");
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = serial_record.split("\\|");
        Object[] balances = new BalanceInfo[recordNum];
        for (int i = 1; i <= recordNum; ++i) {
            String accNo = splits[fieldNum * i + 1];
            String currency = splits[fieldNum * i + 2];
            String balanceStr = splits[fieldNum * i + 3];
            String availableBalanceStr = splits[fieldNum * i + 4];
            String rspMsg = splits[fieldNum * i + 8];
            String rspCode = splits[fieldNum * i + 9];
            if (!"0".equalsIgnoreCase(rspCode)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u884c\u4f59\u989d\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de:%1$s", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), rspMsg));
            }
            balances[i - 1] = new BalanceInfo();
            this.setCurrentBalance((BalanceInfo)balances[0], balanceStr.trim());
            this.setAvailableBalance((BalanceInfo)balances[0], availableBalanceStr.trim());
            this.setBalanceDateTime((BalanceInfo)balances[i - 1], LocalDateTime.now());
            this.setBankAcnt((BalanceInfo)balances[i - 1], rqst.getBankAcntList(), accNo);
            this.setBankCurrency((BalanceInfo)balances[i - 1], currency);
        }
        String bankCurrencies = "";
        for (int i = 0; i < balances.length; ++i) {
            String returnBankCurr = balances[i].getBankCurrency();
            if (inputBankCurr.equalsIgnoreCase(returnBankCurr)) {
                return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])balances));
            }
            bankCurrencies = StringUtils.catWithSpace((String[])new String[]{bankCurrencies, CurrencyUtils.getCurrencyName((String)returnBankCurr)});
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5e01\u79cd(%1$s)\u4e0e\u8d26\u6237\u5b9e\u9645\u5e01\u79cd\u4e0d\u7b26\uff0c\u8bf7\u4ee5[%2$s]\u4f5c\u4e3a\u4f59\u989d\u67e5\u8be2\u7684\u6761\u4ef6\u3002", (String)"TodayBalanceImpl_8", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), CurrencyUtils.getCurrencyName((String)rqst.getBankCurrency()), bankCurrencies));
    }

    public EBBankBalanceResponse parseAccountPoolBalance(BankBalanceRequest rqst, String rspStr) {
        EBBankBalanceResponse balanceResponse = new EBBankBalanceResponse();
        String reslut = "";
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)root);
        Check.checkResponseCode((BankResponse)rsp, (String)"0000");
        Element body = root.getChild("body");
        Element fileFlagElement = JDomUtils.getChildElement((Element)body, (String)"file_flag");
        String fileNumStr = JDomUtils.getChildText((Element)body, (String)"field_num");
        String recordNumStr = JDomUtils.getChildText((Element)body, (String)"record_num");
        int fieldNum = 0;
        int recordNum = 0;
        if (!StringUtils.isEmpty((String)fileNumStr)) {
            fieldNum = Integer.parseInt(fileNumStr);
        }
        if (!StringUtils.isEmpty((String)recordNumStr)) {
            recordNum = Integer.parseInt(recordNumStr);
        }
        if (null != fileFlagElement) {
            Element serialRecord;
            String fileFlag = fileFlagElement.getText();
            if (!(null != fileFlag && fileFlag.equalsIgnoreCase("1") || null == (serialRecord = JDomUtils.getChildElement((Element)body, (String)"serial_record")))) {
                reslut = serialRecord.getText();
                balanceResponse = BankBusinessConfig.isFixedAcnt(rqst.getAcnt().getAccNo()) ? this.parseAccountFixedResponse(reslut, fieldNum, recordNum, rqst.getAcnt().getAccNo()) : this.parseAccountPoolResponse(reslut, fieldNum, recordNum);
            }
        } else {
            Element serialRecord = JDomUtils.getChildElement((Element)body, (String)"serial_record");
            if (null != serialRecord) {
                reslut = serialRecord.getText();
                balanceResponse = BankBusinessConfig.isFixedAcnt(rqst.getAcnt().getAccNo()) ? this.parseAccountFixedResponse(reslut, fieldNum, recordNum, rqst.getAcnt().getAccNo()) : this.parseAccountPoolResponse(reslut, fieldNum, recordNum);
            }
        }
        return balanceResponse;
    }

    private EBBankBalanceResponse parseAccountFixedResponse(String response, int fieldNum, int recordNum, String accountNo) {
        EBBankBalanceResponse bankResponse = new EBBankBalanceResponse();
        if (!"".equalsIgnoreCase(response)) {
            String[] fileds = response.split("\\|");
            Object[] balances = new BalanceInfo[recordNum];
            for (int i = 1; i < recordNum + 1; ++i) {
                String balance = fileds[i * fieldNum + 5];
                String currency = fileds[i * fieldNum + 1];
                String isFreeze = fileds[i * fieldNum + 7];
                balances[i - 1] = new BalanceInfo();
                if (isFreeze.equalsIgnoreCase("0")) {
                    BankAcnt bankAcnt = new BankAcnt();
                    bankAcnt.setAccNo(accountNo);
                    logger.info("\u67e5\u8be2\u5b9a\u671f\u6237\u8d26\u53f7\uff1a" + accountNo);
                    this.setBankAcnt((BalanceInfo)balances[i - 1], bankAcnt);
                    this.setCurrentBalance((BalanceInfo)balances[i - 1], balance.trim());
                    this.setLastDayAvlBalance((BalanceInfo)balances[i - 1], "0.00");
                    this.setBalanceDateTime((BalanceInfo)balances[i - 1], LocalDateTime.now());
                    this.setBankCurrency((BalanceInfo)balances[i - 1], currency);
                    continue;
                }
                logger.error("\u4ea4\u884c\u8d26\u53f7\uff1a " + accountNo + "\u67e5\u8be2\u5931\u8d25,\u8be5\u8d26\u53f7\u5df2\u7ecf\u88ab\u51bb\u7ed3");
            }
            bankResponse.setBalances((List)Lists.newArrayList((Object[])balances));
        }
        return bankResponse;
    }

    private EBBankBalanceResponse parseAccountPoolResponse(String response, int fieldNum, int recordNum) {
        EBBankBalanceResponse bankResponse = new EBBankBalanceResponse();
        if (!"".equalsIgnoreCase(response)) {
            String[] fileds = response.split("\\|");
            Object[] balances = new BalanceInfo[recordNum];
            for (int i = 1; i < recordNum + 1; ++i) {
                String account = fileds[i * fieldNum + 0];
                String successFlag = fileds[i * fieldNum + 11];
                String errorMsg = fileds[i * fieldNum + 10];
                String balance = fileds[i * fieldNum + 5];
                String visualBalance = fileds[i * fieldNum + 4];
                String lastDayVisualBalance = fileds[i * fieldNum + 6];
                String currency = fileds[i * fieldNum + 1];
                String dateStr = fileds[i * fieldNum + 3];
                String availableBalance = fileds[i * fieldNum + 9];
                balances[i - 1] = new BalanceInfo();
                if (successFlag.equalsIgnoreCase("0")) {
                    BankAcnt bankAcnt = new BankAcnt();
                    bankAcnt.setAccNo(account);
                    this.setBankAcnt((BalanceInfo)balances[i - 1], bankAcnt);
                    this.setAvailableBalance((BalanceInfo)balances[i - 1], visualBalance.trim());
                    this.setCurrentBalance((BalanceInfo)balances[i - 1], balance.trim());
                    this.setLastDayAvlBalance((BalanceInfo)balances[i - 1], "0.00");
                    this.setBalanceDateTime((BalanceInfo)balances[i - 1], LocalDateTime.now());
                    this.setBankCurrency((BalanceInfo)balances[i - 1], currency);
                    continue;
                }
                logger.error("\u4ea4\u884c\u8d26\u53f7\uff1a " + account + " \u8574\u901a\u73b0\u91d1\u6c60\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de:" + errorMsg);
            }
            bankResponse.setBalances((List)Lists.newArrayList((Object[])balances));
        }
        return bankResponse;
    }

    private BalanceInfo getLastDayBalance(BankBalanceRequest rqst) {
        BalanceInfo lastDayBalance = new BalanceInfo();
        try {
            LocalDate yeserday = LocalDate.now().minusDays(1L);
            BankBalanceRequest balanceRequest = new BankBalanceRequest();
            balanceRequest.setHeader(rqst.getHeader());
            balanceRequest.setCurrency(rqst.getCurrency());
            balanceRequest.setStartDate(yeserday);
            balanceRequest.setEndDate(yeserday);
            EBBankBalanceResponse hisBalance = new HisBalanceImpl().hisBalance(balanceRequest);
            List balances = hisBalance.getBalances();
            if (Objects.nonNull(balances) && balances.size() > 1) {
                lastDayBalance.setLastDayAvlBalance(((BalanceInfo)balances.get(0)).getAvailableBalance());
                logger.info("\u4ea4\u884c\u4e0a\u65e5\u4f59\u989d:" + lastDayBalance.getAvailableBalance());
            } else {
                logger.info("\u6ca1\u67e5\u8be2\u51fa\u4e0a\u65e5\u4f59\u989d");
            }
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4ea4\u884c\u4e0a\u65e5\u4f59\u989d\u51fa\u9519.", (Throwable)e);
        }
        return lastDayBalance;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "310101";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        return !Utils.isHKBiz(((BankAcnt)request.getBankAcntList().get(0)).getAccNo());
    }
}

