/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OsaDetailHelper {
    public static String packTodayDetail(BankDetailRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = BOCOM_DC_Packer.packRoot((String)"310902");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packHisDetail(BankDetailRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = BOCOM_DC_Packer.packRoot((String)"310903");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static List<DetailInfo> parseDetail(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s", (String)"DetailParser_4", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        int recordNum = Integer.parseInt(record_num);
        if (0 == recordNum) {
            return detailList;
        }
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = StringUtils.split((String)serial_record, (String)"|");
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 1; i <= recordNum; ++i) {
            String dateStr = splits[fieldNum * i + 1];
            String timeStr = splits[fieldNum * i + 2];
            String detailSequence = splits[fieldNum * i + 3];
            String flowSequence = splits[fieldNum * i + 4];
            String accNo = splits[fieldNum * i + 5];
            String cdFlag = splits[fieldNum * i + 6];
            String currency = splits[fieldNum * i + 7];
            String amount = splits[fieldNum * i + 8];
            String balance = splits[fieldNum * i + 9];
            String oppAccNo = splits[fieldNum * i + 10];
            String oppAccName = splits[fieldNum * i + 11];
            String oppAccBank = splits[fieldNum * i + 12];
            String postscript = splits[fieldNum * i + 14];
            String remark = splits[fieldNum * i + 15];
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(accNo);
            detail.setTransDate(LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(LocalDateTime.parse(dateStr + timeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            detail.setCurrency(currency);
            if ("D".equalsIgnoreCase(cdFlag)) {
                detail.setDebitAmount(new BigDecimal(amount));
                detail.setCreditAmount(ParserUtils.ZERO);
            } else if ("C".equalsIgnoreCase(cdFlag)) {
                detail.setDebitAmount(ParserUtils.ZERO);
                detail.setCreditAmount(new BigDecimal(amount));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7Drcrf=%1$s\u3002", (String)"DetailParser_5", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), cdFlag));
            }
            if (StringUtils.isNotEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(oppAccName);
            detail.setOppBankName(oppAccBank);
            detail.setExplanation(postscript);
            JSONObject receiptJson = new JSONObject();
            receiptJson.put("accNo", (Object)accNo);
            receiptJson.put("transDate", (Object)dateStr);
            receiptJson.put("serialNo", (Object)(detailSequence + "@" + flowSequence));
            receiptJson.put("logNo", (Object)flowSequence);
            receiptJson.put("detailSequence", (Object)detailSequence);
            receiptJson.put("Amount", (Object)amount);
            receiptJson.put("postscript", (Object)postscript);
            receiptJson.put("remark", (Object)remark);
            receiptJson.put("cdFlag", (Object)cdFlag);
            detail.setJsonMap(receiptJson.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, dateStr, receiptJson.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(detailSequence);
            detailList.add(detail);
        }
        return detailList;
    }
}

