/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.hk;

import com.google.common.collect.Lists;
import java.util.List;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.util.Check;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Utils {
    public static Element createBody(Element root) {
        return JDomUtils.addChild((Element)root, (String)"body");
    }

    public static String intoString(Element root) {
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public static Element getBody(String respStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)respStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)root);
        Check.checkResponseCode((BankResponse)rsp, (String)"0000");
        return root.getChild("body");
    }

    public static String getPyrBank(String accNo) {
        String countryArea = BankBusinessConfig.getCountryAreaAccount(accNo);
        if ("01".equalsIgnoreCase(countryArea)) {
            return "1";
        }
        if ("04".equalsIgnoreCase(countryArea)) {
            return "3";
        }
        if ("02".equalsIgnoreCase(countryArea)) {
            return "4";
        }
        if ("03".equalsIgnoreCase(countryArea)) {
            return "2";
        }
        return "";
    }

    public static String getRemitBank(String accNo) {
        String countryArea = BankBusinessConfig.getCountryAreaAccount(accNo);
        if ("01".equalsIgnoreCase(countryArea)) {
            return "1";
        }
        if ("04".equalsIgnoreCase(countryArea)) {
            return "3";
        }
        if ("02".equalsIgnoreCase(countryArea)) {
            return "4";
        }
        if ("03".equalsIgnoreCase(countryArea)) {
            return "2";
        }
        if ("05".equalsIgnoreCase(countryArea)) {
            return "5";
        }
        if ("06".equalsIgnoreCase(countryArea)) {
            return "6";
        }
        if ("07".equalsIgnoreCase(countryArea)) {
            return "7";
        }
        if ("100".equalsIgnoreCase(countryArea)) {
            return "100";
        }
        return "";
    }

    public static String getCountry(String country) {
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(country);
        if (null == code) {
            code = ISOCountryUtils.getInstance().getCountryInfo(country);
        }
        if (code == null) {
            return "";
        }
        return code.geteChart2();
    }

    public static boolean isHKBiz(String accNo) {
        String countryArea = BankBusinessConfig.getCountryAreaAccount(accNo);
        return !"00".equalsIgnoreCase(countryArea);
    }

    public static List<MultiLangEnumBridge> getBankCNList() {
        return Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5883\u5185\u5206\u884c", "BankBusinessConfig_509", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("\u9999\u6e2f\u5206\u884c", "BankBusinessConfig_510", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("\u9999\u6e2f\u5b50\u884c", "BankBusinessConfig_511", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("\u79bb\u5cb8\u4e2d\u5fc3", "BankBusinessConfig_512", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("\u6fb3\u95e8\u5206\u884c", "BankBusinessConfig_513", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("\u9996\u5c14\u5206\u884c", "BankBusinessConfig_514", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("\u80e1\u5fd7\u660e\u5206\u884c", "BankBusinessConfig_515", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("\u5883\u5916\u4ea4\u884c", "BankBusinessConfig_516", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("\u5883\u5916\u975e\u4ea4\u884c", "BankBusinessConfig_517", "ebg-aqap-banks-bocom-dc"), new MultiLangEnumBridge("swift\u5171\u4eab\u5e73\u53f0", "BankBusinessConfig_518", "ebg-aqap-banks-bocom-dc")});
    }

    public static List<String> getCountryAreaCodeList() {
        return Lists.newArrayList((Object[])new String[]{"00", "01", "02", "03", "04", "05", "06", "88", "99", "100"});
    }

    public static String getBankFlagForInquiryPay(String countryAreCode) {
        if ("01".equalsIgnoreCase(countryAreCode)) {
            return "0";
        }
        if ("02".equalsIgnoreCase(countryAreCode)) {
            return "3";
        }
        if ("03".equalsIgnoreCase(countryAreCode)) {
            return "1";
        }
        if ("04".equalsIgnoreCase(countryAreCode)) {
            return "2";
        }
        if ("05".equalsIgnoreCase(countryAreCode)) {
            return "5";
        }
        if ("06".equalsIgnoreCase(countryAreCode)) {
            return "6";
        }
        if ("100".equalsIgnoreCase(countryAreCode)) {
            return "100";
        }
        return "";
    }
}

