/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.individual;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.payment.BOCOMUseConvertor;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public static String pay330002(PaymentInfo[] paymentInfos) {
        String explanation;
        Element root = BOCOM_DC_Packer.packRoot((String)"330002");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        String busiType = BOCOMUseConvertor.convert2BOCOMType((String)"330002", (PaymentInfo)paymentInfos[0]);
        JDomUtils.addChild((Element)body, (String)"type", (String)busiType);
        JDomUtils.addChild((Element)body, (String)"pay_month", (String)new SimpleDateFormat("yyyyMM").format(new Date()));
        boolean needSubSummary = BankBusinessConfig.isNeedSubSummary();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            explanation = "";
            if (paymentInfos[0].is2Merge() || !paymentInfos[0].is2Merge() && paymentInfos.length > 1) {
                PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)paymentInfos[0]);
                explanation = PaymentUtil.substringChinese((boolean)needSubSummary, (String)BizNoUtil.cont((String)paymentInfos[0].getBankBatchSeqId(), (String)paymentInfos[0].getExplanation()), (int)60, (String)RequestContextUtils.getCharset());
            } else if (!paymentInfos[0].is2Merge() && paymentInfos.length == 1) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
                explanation = PaymentUtil.substringChinese((boolean)needSubSummary, (String)BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)paymentInfos[0].getExplanation()), (int)60, (String)RequestContextUtils.getCharset());
            }
            JDomUtils.addChild((Element)body, (String)"summary", (String)explanation);
        } else {
            explanation = PaymentUtil.substringChinese((boolean)needSubSummary, (String)paymentInfos[0].getExplanation(), (int)60, (String)RequestContextUtils.getCharset());
            JDomUtils.addChild((Element)body, (String)"summary", (String)explanation);
        }
        String busiNo = BankBusinessConfig.getPayrollNo(paymentInfos[0].getAccNo(), busiType);
        if (StringUtils.isEmpty((String)busiNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u7ef4\u62a4\u3002", (String)"PayPacker_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"busi_no", (String)busiNo);
        if (paymentInfos[0].is2Merge()) {
            JDomUtils.addChild((Element)body, (String)"mailflg", (String)"Y");
        } else {
            JDomUtils.addChild((Element)body, (String)"mailflg", (String)"N");
        }
        Element tran = JDomUtils.addChild((Element)body, (String)"tran");
        BigDecimal totalAmount = new BigDecimal("0");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element rcd = JDomUtils.addChild((Element)tran, (String)"rcd");
            JDomUtils.addChild((Element)rcd, (String)"card_no", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)rcd, (String)"acname", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)rcd, (String)"card_flag", (String)"0");
            BigDecimal amount = paymentInfos[i].getAmount();
            totalAmount = totalAmount.add(amount);
            JDomUtils.addChild((Element)rcd, (String)"amt", (String)amount.toString());
            JDomUtils.addChild((Element)rcd, (String)"busino", (String)paymentInfos[i].getBankDetailSeqID());
        }
        JDomUtils.addChild((Element)body, (String)"sum", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"sum_amt", (String)totalAmount.toString());
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return message;
    }

    public static String pay330003(PaymentInfo[] paymentInfos) {
        String explanation;
        Element root = BOCOM_DC_Packer.packRoot((String)"330003");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        String busiType = BOCOMUseConvertor.convert2BOCOMType((String)"330003", (PaymentInfo)paymentInfos[0]);
        JDomUtils.addChild((Element)body, (String)"type", (String)busiType);
        JDomUtils.addChild((Element)body, (String)"pay_month", (String)new SimpleDateFormat("yyyyMM").format(new Date()));
        boolean needSubSummary = BankBusinessConfig.isNeedSubSummary();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            explanation = "";
            if (paymentInfos[0].is2Merge() || !paymentInfos[0].is2Merge() && paymentInfos.length > 1) {
                PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo[])paymentInfos);
                explanation = PaymentUtil.substringChinese((boolean)needSubSummary, (String)BizNoUtil.cont((String)paymentInfos[0].getBankBatchSeqId(), (String)paymentInfos[0].getExplanation()), (int)60, (String)RequestContextUtils.getCharset());
            } else if (!paymentInfos[0].is2Merge() && paymentInfos.length == 1) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
                explanation = PaymentUtil.substringChinese((boolean)needSubSummary, (String)BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)paymentInfos[0].getExplanation()), (int)60, (String)RequestContextUtils.getCharset());
            }
            JDomUtils.addChild((Element)body, (String)"summary", (String)explanation);
        } else {
            explanation = PaymentUtil.substringChinese((boolean)needSubSummary, (String)paymentInfos[0].getExplanation(), (int)60, (String)RequestContextUtils.getCharset());
            JDomUtils.addChild((Element)body, (String)"summary", (String)explanation);
        }
        String busiNo = BankBusinessConfig.getPayrollNo(paymentInfos[0].getAccNo(), busiType);
        if (StringUtils.isEmpty((String)busiNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u7ef4\u62a4\u3002", (String)"PayPacker_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"busi_no", (String)busiNo);
        if (paymentInfos[0].is2Merge()) {
            if (paymentInfos.length > 1) {
                JDomUtils.addChild((Element)body, (String)"mailflg", (String)"Y");
            } else {
                JDomUtils.addChild((Element)body, (String)"mailflg", (String)"A");
            }
        } else {
            JDomUtils.addChild((Element)body, (String)"mailflg", (String)"N");
        }
        JDomUtils.addChild((Element)body, (String)"selsec_flg", (String)BankBusinessConfig.getSelectFlag());
        Element tran = JDomUtils.addChild((Element)body, (String)"tran");
        BigDecimal totalAmount = new BigDecimal("0");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element rcd = JDomUtils.addChild((Element)tran, (String)"rcd");
            JDomUtils.addChild((Element)rcd, (String)"card_no", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)rcd, (String)"acname", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)rcd, (String)"card_flag", (String)"0");
            BigDecimal amount = paymentInfos[i].getAmount();
            totalAmount = totalAmount.add(amount);
            JDomUtils.addChild((Element)rcd, (String)"amt", (String)amount.toString());
            if (paymentInfos[0].is2Merge()) {
                JDomUtils.addChild((Element)rcd, (String)"busino", (String)paymentInfos[i].getBankBatchSeqID());
                continue;
            }
            JDomUtils.addChild((Element)rcd, (String)"busino", (String)paymentInfos[i].getBankDetailSeqID());
        }
        JDomUtils.addChild((Element)body, (String)"sum", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"sum_amt", (String)totalAmount.toString());
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return message;
    }
}

