/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.individual.otherbank;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.payment.BOCOMUseConvertor;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.otherbank.BatchQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BatchQueryPayImpl.class;
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u738b\u6dbf", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "210229";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1/\u8de8\u884c\u6279\u91cf\u4ee3\u53d1", (String)"BatchPayImpl_2", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        return this.pay210229(paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]));
    }

    private String pay210229(PaymentInfo[] paymentInfos) throws EBServiceException {
        Element root = BOCOM_DC_Packer.packRoot((String)this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"dealNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"payAccNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"payAccName", (String)paymentInfos[0].getAccName());
        String busiType = BOCOMUseConvertor.convert2BOCOMType((String)this.getBizCode(), (PaymentInfo)paymentInfos[0]);
        String busiNo = BankBusinessConfig.getPayrollNo(paymentInfos[0].getAccNo(), busiType);
        JDomUtils.addChild((Element)body, (String)"CAgrNo", (String)(busiNo + busiType));
        JDomUtils.addChild((Element)body, (String)"totalNum", (String)(paymentInfos.length + ""));
        JDomUtils.addChild((Element)body, (String)"totalAmt", (String)this.getTotalAmt(paymentInfos));
        JDomUtils.addChild((Element)body, (String)"payMonth", (String)new SimpleDateFormat("yyyyMM").format(new Date()));
        if (paymentInfos.length > 1) {
            JDomUtils.addChild((Element)body, (String)"unitFlg", (String)"1");
        } else {
            JDomUtils.addChild((Element)body, (String)"unitFlg", (String)"A");
        }
        StringBuilder payAccNo = new StringBuilder();
        StringBuilder payAccName = new StringBuilder();
        StringBuilder tranAmt = new StringBuilder();
        StringBuilder rem = new StringBuilder();
        if (paymentInfos.length == 1) {
            payAccNo.append(paymentInfos[0].getIncomeAccNo());
            payAccName.append(paymentInfos[0].getIncomeAccName());
            tranAmt.append(BigDecimalHelper.plain2((BigDecimal)paymentInfos[0].getAmount()));
            rem.append(paymentInfos[0].getExplanation());
        } else {
            for (int i = 0; i < paymentInfos.length; ++i) {
                payAccNo.append(paymentInfos[i].getIncomeAccNo()).append("|");
                payAccName.append(paymentInfos[i].getIncomeAccName()).append("|");
                tranAmt.append(BigDecimalHelper.plain2((BigDecimal)paymentInfos[i].getAmount())).append("|");
                rem.append(paymentInfos[i].getExplanation()).append("|");
            }
        }
        JDomUtils.addChild((Element)body, (String)"recAccNo", (String)payAccNo.toString());
        JDomUtils.addChild((Element)body, (String)"recAccName", (String)payAccName.toString());
        JDomUtils.addChild((Element)body, (String)"tranAmt", (String)tranAmt.toString());
        boolean needSubSummary = BankBusinessConfig.isNeedSubSummary();
        String noteRem = rem.toString();
        String exp = paymentInfos[0].getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            if (paymentInfos.length == 1) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
                noteRem = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqID(), (String)noteRem);
            } else {
                PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo[])paymentInfos);
                exp = BizNoUtil.cont((String)paymentInfos[0].getBankBatchSeqId(), (String)exp);
            }
        }
        JDomUtils.addChild((Element)body, (String)"rem", (String)noteRem);
        JDomUtils.addChild((Element)body, (String)"summary", (String)PaymentUtil.substringChinese((boolean)needSubSummary, (String)exp, (int)60, (String)RequestContextUtils.getCharset()));
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return message;
    }

    private String getTotalAmt(PaymentInfo[] paymentInfos) {
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            totalAmt = BigDecimalHelper.add((BigDecimal)totalAmt, (BigDecimal)paymentInfos[i].getAmount());
        }
        return BigDecimalHelper.plain2((BigDecimal)totalAmt);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)ap);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u63d0\u4ea4\u6210\u529f", (String)"BatchPayImpl_3", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

