/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.salary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryAuthoritySalaryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 3000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = BOCOM_DC_Packer.packRoot((String)"310207");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"ogl_serial_no", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"query_flag", (String)"1");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot((Element)root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        int fieldNum = Integer.parseInt(field_num);
        int recordNum = Integer.parseInt(record_num);
        if (0 == recordNum) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        List paymentInfoAll = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfoAll);
        List paymentInfos1 = request.getPaymentInfos();
        HashMap<String, PaymentInfo> paymentInfoMap = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo paymentInfo : paymentInfos1) {
            String keyByPaymentInfo = PayStatusMatchUtil.getKeyByPaymentInfo((PaymentInfo)paymentInfo, (boolean)false, (boolean)false);
            paymentInfoMap.put(keyByPaymentInfo, paymentInfo);
        }
        String[] splits = StringUtils.split((String)serial_record, (String)"|");
        for (int i = 1; i <= recordNum; ++i) {
            String amount = splits[fieldNum * i + 9];
            String accountNo = splits[fieldNum * i + 10];
            String accountName = splits[fieldNum * i + 11];
            String stat = splits[fieldNum * i + 12];
            String msg = splits[fieldNum * i + 13];
            String key = this.selectPaymentKey(accountNo, accountName, amount);
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfoMap.get(key);
            if (paymentInfo == null) continue;
            this.handlePayStatus(paymentInfo, stat, msg);
        }
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos1, (boolean)false, (boolean)false);
        this.processingBankItemDataHandler(splits, fieldNum, recordNum);
        PayStatusMatchUtil.backBatchSameItemHandler((List)paymentInfos1, (boolean)false, (boolean)false);
        return new EBBankPayResponse(paymentInfos1);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "310207";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u4ed8\u6b3e\u67e5\u8be2\u63a5\u53e3", (String)"QueryAuthoritySalaryPaymentImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public String selectPaymentKey(String incomeAccNo, String incomeAccName, String amount) {
        BigDecimal bigDecimal = new BigDecimal(amount).setScale(2);
        StringBuilder buffer = new StringBuilder();
        buffer.append(incomeAccNo).append(incomeAccName).append(bigDecimal.toPlainString());
        return buffer.toString();
    }

    private void handlePayStatus(PaymentInfo paymentInfo, String stat, String errorMessage) {
        if ("F".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)stat, (String)errorMessage);
        } else if ("E".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)stat, (String)errorMessage);
        } else if ("0".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)stat, (String)errorMessage);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)stat, (String)errorMessage);
        }
    }

    private void processingBankItemDataHandler(String[] splits, int fieldNum, int recordNum) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (int i = 1; i <= recordNum; ++i) {
                    String amount = splits[fieldNum * i + 9];
                    String accountNo = splits[fieldNum * i + 10];
                    String accountName = splits[fieldNum * i + 11];
                    String stat = splits[fieldNum * i + 12];
                    String msg = splits[fieldNum * i + 13];
                    String bankDataKey = this.selectPaymentKey(accountNo, accountName, amount);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, stat, msg);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }
}

