/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbsg.h2h.services.handler;

import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT940Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SCBSG_H2H_CAMT053_Handler
extends AbstractMT940Handler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SCBSG_H2H_CAMT053_Handler.class);

    public void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        try {
            this.processHisDetail(file, detailInfoList, payInfoList, balanceInfoList);
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u62a5\u544a[%1$s]\u51fa\u9519\u3002", (String)"SCBSG_H2H_CAMT052_Handler_1", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), file.getName()), (Throwable)e);
        }
    }

    private void processHisDetail(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element bkToCstmrStmt = root.getChild("BkToCstmrStmt", ns);
        List stmtList = bkToCstmrStmt.getChildren("Stmt", ns);
        for (Element stmt : stmtList) {
            Element acct = stmt.getChild("Acct", ns);
            Element id = acct.getChild("Id", ns);
            Element othr = id.getChild("Othr", ns);
            String acntNumber = othr.getChildText("Id", ns);
            List list = stmt.getChildren("Ntry", ns);
            for (Element Ntry : list) {
                OverseaDetail detail = new OverseaDetail();
                Element amt = Ntry.getChild("Amt", ns);
                String amtText = amt.getText();
                String ccy = amt.getAttributeValue("Ccy");
                String cdtDbtInd = Ntry.getChildText("CdtDbtInd", ns);
                Element valDt = Ntry.getChild("ValDt", ns);
                detail.setTxDate(LocalDate.parse(valDt.getChildText("Dt", ns), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                detail.setNumber(acntNumber);
                detail.setPayBankName(this.context.getBankVersionID());
                detail.setPayBankVersion(this.context.getBankVersionID());
                detail.setDetailFileName(file.getName());
                detail.setCreatetime(LocalDateTime.now());
                detail.setCustomId(EBContext.getContext().getCustomID());
                detail.setCurrency(ccy);
                detail.setTxAmt(new BigDecimal(amtText));
                if ("DBIT".equalsIgnoreCase(cdtDbtInd)) {
                    detail.setCordFlag("DEBIT");
                } else if ("CRDT".equalsIgnoreCase(cdtDbtInd)) {
                    detail.setCordFlag("CREDIT");
                } else {
                    this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b,\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411\u3002", (String)"SCBSG_H2H_CAMT052_Handler_2", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), cdtDbtInd));
                }
                Element ntryDtls = Ntry.getChild("NtryDtls", ns);
                Element txDtls = ntryDtls.getChild("TxDtls", ns);
                Element rmtInf = txDtls.getChild("RmtInf", ns);
                List ustrd = rmtInf.getChildren("Ustrd", ns);
                if (CollectionUtil.isNotEmpty((Collection)ustrd)) {
                    StringBuilder sb = new StringBuilder();
                    for (Element element : ustrd) {
                        sb.append(element.getText()).append(",");
                    }
                    String explain = sb.substring(0, sb.length() - 1);
                    if (explain.length() > 500) {
                        explain = explain.substring(0, 500);
                    }
                    detail.setExplanation(explain);
                }
                detailInfoList.add(detail);
            }
        }
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return fileName.contains("CAMT053") || fileName.contains("CAMT53");
    }
}

