/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbsg.h2h.services.payment;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scbsg.h2h.BankBusinessConfig;
import kd.ebg.aqap.banks.scbsg.h2h.services.utils.SCB_H2H_Utils;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SCB_CommonPacker {
    private static Map<String, String> map = new HashMap<String, String>(50);

    public static Element packPayXmlhead(List<PaymentInfo> paymentInfos, Element CstmrCdtTrfInitn) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element GrpHdr = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"GrpHdr").setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"MsgId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"CreDtTm", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"))).setNamespace(ns1);
        Element NbOfTxs = JDomUtils.addChild((Element)GrpHdr, (String)"NbOfTxs").setNamespace(ns1);
        NbOfTxs.addContent(String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)GrpHdr, (String)"CtrlSum").setNamespace(ns1);
        Element InitgPty = JDomUtils.addChild((Element)GrpHdr, (String)"InitgPty").setNamespace(ns1);
        JDomUtils.addChild((Element)InitgPty, (String)"Nm", (String)paymentInfo.getAccName()).setNamespace(ns1);
        return GrpHdr;
    }

    public static Element packPayXmlPmtInfo(List<PaymentInfo> paymentInfos, Element CstmrCdtTrfInitn) {
        LocalDateTime bookingTime;
        Element lclInstrm;
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String serviceLevel = paymentInfo.getServiceLevel();
        String pmtMtd = paymentInfo.getPaymentMethod();
        String accNo = paymentInfo.getAccNo();
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element PmtInf = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"PmtInf").setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtInfId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtMtd", (String)pmtMtd).setNamespace(ns1);
        Element PmtTpInf = JDomUtils.addChild((Element)PmtInf, (String)"PmtTpInf").setNamespace(ns1);
        Element SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns1);
        JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)serviceLevel).setNamespace(ns1);
        if ("SCBTH_SFTP".equalsIgnoreCase(paymentInfo.getBankVersionID()) && "ACH".equalsIgnoreCase(paymentInfo.getUseCN())) {
            lclInstrm = JDomUtils.addChild((Element)PmtTpInf, (String)"LclInstrm").setNamespace(ns1);
            JDomUtils.addChild((Element)lclInstrm, (String)"Prtry", (String)"ND").setNamespace(ns1);
        }
        if ("IBFT".equalsIgnoreCase(paymentInfo.getUseCN()) && !"SCBSG_SFTP".equalsIgnoreCase(paymentInfo.getBankVersionID())) {
            lclInstrm = JDomUtils.addChild((Element)PmtTpInf, (String)"LclInstrm").setNamespace(ns1);
            if ("SCBHK_SFTP".equalsIgnoreCase(paymentInfo.getBankVersionID())) {
                JDomUtils.addChild((Element)lclInstrm, (String)"Prtry", (String)"PTA").setNamespace(ns1);
            } else {
                JDomUtils.addChild((Element)lclInstrm, (String)"Prtry", (String)"A2A").setNamespace(ns1);
            }
        }
        if ((bookingTime = paymentInfo.getBookingTime()) == null) {
            bookingTime = LocalDateTime.now();
        }
        JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)bookingTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).setNamespace(ns1);
        Element Dbtr = JDomUtils.addChild((Element)PmtInf, (String)"Dbtr").setNamespace(ns1);
        JDomUtils.addChild((Element)Dbtr, (String)"Nm", (String)BankBusinessConfig.getPayCompanyName((String)accNo)).setNamespace(ns1);
        Element DbtrAcct = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAcct").setNamespace(ns1);
        Element DbtrAcct_Id = JDomUtils.addChild((Element)DbtrAcct, (String)"Id").setNamespace(ns1);
        Element DbtrAcct_Othr = JDomUtils.addChild((Element)DbtrAcct_Id, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct_Othr, (String)"Id", (String)accNo).setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct, (String)"Ccy", (String)paymentInfo.getCurrency()).setNamespace(ns1);
        Element DbtrAgt = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAgt").setNamespace(ns1);
        Element FinInstnId = JDomUtils.addChild((Element)DbtrAgt, (String)"FinInstnId").setNamespace(ns1);
        String bic = BankBusinessConfig.getBicCode((String)accNo);
        if (StringUtils.isEmpty((String)bic)) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u7684BIC swift code\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728[\u94f6\u4f01\u8d26\u6237]\u9875\u9762\u7ef4\u62a4\u3002", (String)"SCB_CommonPacker_0", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)bic).setNamespace(ns1);
        return PmtInf;
    }

    public static String packPay(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Document");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = SCB_CommonPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn);
        Element PmtInf = SCB_CommonPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"InstrId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)info.getActualAmount().toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(info.getActualAmount());
            InstdAmt.setAttribute("Ccy", info.getPayCurrency());
            if (info.getPayerFeeType().equalsIgnoreCase("01")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
            } else if (info.getPayerFeeType().equalsIgnoreCase("02")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
            } else if (info.getPayerFeeType().equalsIgnoreCase("03")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            if (!StringUtils.isEmpty((String)info.getIncomeSwiftCode())) {
                JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)info.getIncomeSwiftCode()).setNamespace(ns1);
            }
            if ("SCBTH_SFTP".equalsIgnoreCase(info.getBankVersionID()) && ("ACH".equalsIgnoreCase(info.getUseCN()) || "BT".equalsIgnoreCase(info.getUseCN()) || "RTGS".equalsIgnoreCase(info.getUseCN()) || "LBT".equalsIgnoreCase(info.getUseCN()))) {
                SCB_CommonPacker.addBranchId(info, CdtrAgt, ns1);
            }
            if ("SCBMU_SFTP".equalsIgnoreCase(info.getBankVersionID()) && "ACH".equalsIgnoreCase(info.getUseCN())) {
                SCB_CommonPacker.addBranchId(info, CdtrAgt, ns1);
            }
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)SCB_H2H_Utils.formatStringByLength((String)info.getIncomeAccName(), (Integer)140)).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
            if (null == code) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6%s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5339\u914d\u56fd\u5bb6\u4ee3\u7801\u8868\u3002", (String)"PayImpl_0", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), info.getIncomeCountry()));
            }
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
            if (StringUtils.isNotEmpty((String)info.getIncomeAddress())) {
                JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"AdrLine", (String)info.getIncomeAddress()).setNamespace(ns1);
            }
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            String incomeAccNo = info.getIncomeAccNo();
            String incomeSwiftCode = info.getIncomeSwiftCode();
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)incomeAccNo).setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct, (String)"Nm", (String)info.getIncomeAccName()).setNamespace(ns1);
            if (StringUtils.isNotEmpty((String)info.getBusinessTypeCode())) {
                Element Purp = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Purp").setNamespace(ns1);
                JDomUtils.addChild((Element)Purp, (String)"Prtry", (String)info.getBusinessTypeCode()).setNamespace(ns1);
            }
            if ("SCBIDN_SFTP".equalsIgnoreCase(info.getBankVersionID()) && ("ACH".equalsIgnoreCase(info.getUseCN()) || "RTGS".equalsIgnoreCase(info.getUseCN()))) {
                Element rgltryRptg = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RgltryRptg").setNamespace(ns1);
                Element dtls = JDomUtils.addChild((Element)rgltryRptg, (String)"Dtls").setNamespace(ns1);
                JDomUtils.addChild((Element)dtls, (String)"Tp", (String)(info.is2Individual() ? "1" : "2")).setNamespace(ns1);
            }
            if (StringUtils.isNotEmpty((String)info.getEmails())) {
                Element rltdRmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RltdRmtInf").setNamespace(ns1);
                JDomUtils.addChild((Element)rltdRmtInf, (String)"RmtLctnMtd", (String)"EMAL").setNamespace(ns1);
                JDomUtils.addChild((Element)rltdRmtInf, (String)"RmtLctnElctrncAdr", (String)info.getEmails().replaceAll(";", ",")).setNamespace(ns1);
            }
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)info.getExplanation()).setNamespace(ns1);
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static void addBranchId(PaymentInfo info, Element CdtrAgt, Namespace ns1) {
        Element brnchId = JDomUtils.addChild((Element)CdtrAgt, (String)"BrnchId").setNamespace(ns1);
        String branchCode = info.getIncomeBankLocalClearingBranchCode();
        if (StringUtils.isEmpty((String)branchCode)) {
            branchCode = map.get(info.getIncomeSwiftCode());
        }
        JDomUtils.addChild((Element)brnchId, (String)"Id", (String)branchCode).setNamespace(ns1);
    }

    static {
        map.put("BOTHTHBKXXX", "0000");
        map.put("BKKBTHBKXXX", "0000");
        map.put("KASITHBKXXX", "0000");
        map.put("KRTHTHBKXXX", "0000");
        map.put("CHASTHBXXXX", "0001");
        map.put("TMBKTHBKXXX", "0000");
        map.put("SICOTHBKXXX", "0000");
        map.put("CITITHBXXXX", "0001");
        map.put("SMBCTHBKXXX", "0001");
        map.put("SCBLTHBXXXX", "0101");
        map.put("UBOBTHBKXXX", "0000");
        map.put("UOVBTHBKXXX", "0000");
        map.put("AYUDTHBKXXX", "0000");
        map.put("ICBCTHBKXXX", "0001");
        map.put("BOFATH2XXXX", "0001");
        map.put("GSBATHBKXXX", "9990");
        map.put("HSBCTHBKXXX", "0001");
        map.put("DEUTTHBKXXX", "0001");
        map.put("GOHUTHB1XXX", "0001");
        map.put("BAABTHBKXXX", "0000");
        map.put("MHCBTHBKXXX", "0001");
        map.put("BKCHTHBKXXX", "0000");
        map.put("TIBTTHBKXXX", "0001");
        map.put("TFPCTHB1XXX", "0001");
        map.put("KKPBTHBKXXX", "0000");
        map.put("ICBKTHBKXXX", "0000");
        map.put("THCETHB2XXX", "0000");
        map.put("LAHRTHB2XXX", "0000");
        map.put("STBCTHBKXXX", "0001");
        map.put("BOMMMUPLXXX", "01");
        map.put("ABCKMUMUXXX", "27");
        map.put("AFBLMUMUXXX", "25");
        map.put("BARBMUMUXXX", "02");
        map.put("BAIMMUMUXXX", "14");
        map.put("BKONMUMUXXX", "05");
        map.put("BTBLMUMUXXX", "32");
        map.put("BARCMUMUXXX", "03");
        map.put("CBCLMUMUXXX", "31");
        map.put("HABBMUMUXXX", "06");
        map.put("INILMUMUXXX", "08");
        map.put("SCBLMUMUXXX", "23");
        map.put("SBICMUMUXXX", "22");
        map.put("STCBMUMUXXX", "11");
        map.put("HSBCMUMUXXX", "07");
        map.put("MCBLMUMUXXX", "09");
        map.put("MPCBMUMUXXX", "12");
    }
}

