/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.cmp.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.item.TransTypeEnum;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.repository.DetailInfoRepository;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.repository.OverseaDetailRepository;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public EBBankDetailResponse detail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        EBContext context = EBContext.getContext();
        OverseaDetailRepository bean = (OverseaDetailRepository)SpringContextUtil.getBean(OverseaDetailRepository.class);
        List overseaDetails = bean.queryDetail(context.getCustomID(), startDate, endDate, request.getAcnt().getAccNo(), request.getBankCurrency());
        List<DetailInfo> detailInfos = this.parseDetail(request, overseaDetails);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> parseDetail(BankDetailRequest request, List<OverseaDetail> lists) {
        OverseaDetail overseaDetail;
        int i;
        BankAcnt acnt = request.getAcnt();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        ArrayList<String> kdFlagList = new ArrayList<String>(16);
        for (i = 0; i < lists.size(); ++i) {
            overseaDetail = lists.get(i);
            String kdFlagId = overseaDetail.getExtField1();
            if (!StringUtils.isNotEmpty((String)kdFlagId) || !"DEBIT".equalsIgnoreCase(overseaDetail.getCordFlag())) continue;
            kdFlagList.add(kdFlagId);
        }
        for (i = 0; i < lists.size(); ++i) {
            String extField1;
            overseaDetail = lists.get(i);
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acnt.getAccNo());
            detail.setAccName(acnt.getAccName());
            detail.setBankName(acnt.getBankName());
            detail.setTransDate(overseaDetail.getTxDate());
            detail.setTransTime(overseaDetail.getTxDate().atTime(0, 0, 0));
            String cdFlag = overseaDetail.getCordFlag();
            BigDecimal Amount = overseaDetail.getTxAmt();
            if ("CREDIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(Amount);
                detail.setDebitAmount(BigDecimalHelper.ZERO);
            } else if ("DEBIT".equalsIgnoreCase(cdFlag)) {
                detail.setCreditAmount(BigDecimalHelper.ZERO);
                detail.setDebitAmount(Amount);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u672a\u77e5\u7684'\u501f\u8d37\u6807\u5fd7':%1$s,\u65e0\u6cd5\u786e\u5b9a\u8be5\u7b14\u4ea4\u6613\u7684\u501f\u8d37\u7c7b\u578b\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), cdFlag));
            }
            String txCurrency = overseaDetail.getCurrency();
            detail.setCurrency(txCurrency);
            BigDecimal balance = overseaDetail.getBalance();
            if (balance != null) {
                detail.setBalance(balance);
            }
            if (StringUtils.isNotEmpty((String)(extField1 = overseaDetail.getExtField1())) && extField1.startsWith("kd")) {
                detail.setPayBankDetailSeqID(extField1);
            }
            String detailType = overseaDetail.getDetailType();
            if (TransTypeEnum.REFUND.getName().equalsIgnoreCase(detailType)) {
                if (kdFlagList.contains(extField1)) {
                    detail.setTransType(TransTypeEnum.REFUND.getName());
                } else {
                    DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
                    DetailInfo info = detailInfoRepository.findDetailInfoByKDFlagId(extField1);
                    if (info != null && info.getDebitAmount() != null && info.getDebitAmount().compareTo(BigDecimal.ZERO) > 0) {
                        detail.setTransType(TransTypeEnum.REFUND.getName());
                    }
                }
            }
            detail.setBankDetailNo(overseaDetail.getBankOrderid());
            String oppAcntNo = overseaDetail.getBenefitAccNo();
            String oppAcntName = overseaDetail.getBenefitAccName();
            String oppBankName = overseaDetail.getBenefitBankName();
            detail.setOppAccNo(oppAcntNo);
            detail.setOppAccName(oppAcntName);
            detail.setOppBankName(oppBankName);
            String explanination = overseaDetail.getExplanation();
            detail.setExplanation(explanination);
            detailList.add(detail);
        }
        return detailList;
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        EBContext context = EBContext.getContext();
        OverseaDetailRepository bean = (OverseaDetailRepository)SpringContextUtil.getBean(OverseaDetailRepository.class);
        List overseaDetails = bean.queryDetail(context.getCustomID(), startDate, endDate, request.getAcnt().getAccNo(), request.getBankCurrency());
        List<DetailInfo> detailInfos = this.parseDetail(request, overseaDetails);
        return new EBBankDetailResponse(detailInfos);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

