/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbcasia.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseTradeQhisdRequestV1;
import com.icbc.api.response.MybankEnterpriseTradeQhisdResponseV1;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbcasia.dc.utils.Constants;
import kd.ebg.aqap.banks.icbcasia.dc.utils.RequestUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public EBBankDetailResponse detail(BankDetailRequest req) {
        String accNo = req.getAcnt().getAccNo();
        DefaultIcbcClient client = RequestUtil.createClient(accNo);
        EBBankDetailResponse ebBankDetailResponse = new EBBankDetailResponse();
        try {
            String nextTag = "true";
            MybankEnterpriseTradeQhisdRequestV1 request = new MybankEnterpriseTradeQhisdRequestV1();
            MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1 bizContent = new MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1();
            bizContent.setTransCode("QHISD");
            bizContent.setAccountNo(accNo);
            bizContent.setBeginDate(req.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            bizContent.setEndDate(req.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            bizContent.setCurrency(req.getAcnt().getCurrency());
            bizContent.setBankType("102");
            bizContent.setfSeqno(RequestContextUtils.getRequestContext().getBankRequestSeq());
            LocalDateTime transDate = LocalDateTime.now();
            bizContent.setTranDate(transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            bizContent.setTranTime(transDate.format(DateTimeFormatter.ofPattern("HHmmssSSS")));
            String baseUrl = RequestContextUtils.getBankParameterValue((String)"ip");
            request.setServiceUrl(baseUrl + "api/mybank/enterprise/trade/qhisd/V1");
            request.setBizContent((BizContent)bizContent);
            ArrayList<DetailInfo> list = new ArrayList<DetailInfo>();
            JSONObject reqStr2 = (JSONObject)JSONObject.toJSON((Object)request);
            while (!StringUtils.isEmpty((String)nextTag)) {
                logger.info("\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:" + reqStr2);
                MybankEnterpriseTradeQhisdResponseV1 response = new MybankEnterpriseTradeQhisdResponseV1();
                response = (MybankEnterpriseTradeQhisdResponseV1)client.execute((IcbcRequest)request);
                JSONObject reqStr3 = (JSONObject)JSONObject.toJSON((Object)response);
                logger.info("\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u54cd\u5e94\u6570\u636e:" + reqStr3);
                if (response.isSuccess()) {
                    this.addDetailInfo(list, response);
                    nextTag = response.getNextTag();
                    bizContent = (MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1)request.getBizContent();
                    bizContent.setNextTag(nextTag);
                    logger.info("nextTag:" + nextTag);
                    continue;
                }
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
            }
            logger.info("\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7684\u6570\u636e\u6761\u6570:" + list.size() + "\u6761");
            ebBankDetailResponse.setDetails(list);
            return ebBankDetailResponse;
        }
        catch (Exception e) {
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 ", (String)"DetailImpl_3", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    private void addDetailInfo(List<DetailInfo> list, MybankEnterpriseTradeQhisdResponseV1 response) {
        logger.info("-------------\u89e3\u6790\u8fd4\u56de\u7ed3\u679c\u5e76\u6dfb\u52a0\u5230\u8be6\u60c5\u96c6\u5408\u4e2d start-------------");
        ArrayList responseRds = (ArrayList)response.getRd();
        if (responseRds == null || responseRds.size() == 0) {
            return;
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1 rd : responseRds) {
            DetailInfo info = new DetailInfo();
            info.setAccNo(response.getAccountNo());
            info.setAccName(response.getAccountName());
            info.setCurrency((String)Constants.CURRENCYMAP.get(rd.getThCurrency()));
            info.setOppAccNo(rd.getRecipAccountNo());
            info.setOppAccName(rd.getRecipName());
            info.setOppBankName(rd.getRecipBkName());
            String testDate = RequestContextUtils.getBankParameterValue((String)"testServerDate");
            if (StringUtils.isEmpty((String)testDate)) {
                testDate = rd.getDate();
            }
            info.setTransDate(LocalDate.parse(testDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            info.setTransTime(LocalDateTime.parse(rd.getDate() + this.parseTime(rd.getTradeTime()), DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss")));
            info.setExplanation(rd.getSummary());
            Long payamt = rd.getDebitAmount();
            Long rcvamt = rd.getCreditAmount();
            if (payamt != null) {
                info.setDebitAmount(BigDecimalHelper.div((BigDecimal)new BigDecimal(payamt), (BigDecimal)new BigDecimal("100.00")));
                info.setCreditAmount(BigDecimalHelper.ZERO);
            }
            if (rcvamt != null) {
                info.setCreditAmount(BigDecimalHelper.div((BigDecimal)new BigDecimal(rcvamt), (BigDecimal)new BigDecimal("100.00")));
                info.setDebitAmount(BigDecimalHelper.ZERO);
            }
            info.setBalance(rd.getBalance() == null ? BigDecimalHelper.ZERO : BigDecimalHelper.div((BigDecimal)new BigDecimal(rd.getBalance()), (BigDecimal)new BigDecimal("100.00")));
            String onlySequence = rd.getOnlySequence();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("date", (Object)rd.getDate());
            jsonObject.put("only_sequence", (Object)rd.getMediaId());
            jsonObject.put("debit_amount", (Object)rd.getDebitAmount());
            jsonObject.put("credit_amount", (Object)rd.getCreditAmount());
            Pattern pattern = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2})(\\d{5})(\\d{11})(\\d{5})$");
            Matcher onlySeqMatcher = pattern.matcher(onlySequence);
            if (onlySeqMatcher.matches()) {
                String seq = onlySeqMatcher.group(3) + onlySeqMatcher.group(4);
                jsonObject.put("new_only_sequence", (Object)seq);
            }
            info.setJsonMap(jsonObject.toJSONString());
            info.setBankDetailNo(rd.getOnlySequence());
            String dateStr = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(response.getAccountNo(), dateStr, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            info.setReceiptNo(receiptNo);
            list.add(info);
        }
        logger.info("-------------\u89e3\u6790\u8fd4\u56de\u7ed3\u679c\u5e76\u6dfb\u52a0\u5230\u8be6\u60c5\u96c6\u5408\u4e2d End-------------");
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QHISD";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6", (String)"DetailImpl_4", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]);
    }

    private String parseTime(String time) {
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> res = new ArrayList<String>(3);
        for (int i = 0; i < time.length() && res.size() != 3; ++i) {
            char c = time.charAt(i);
            if (!Character.isDigit(c)) continue;
            tmp.append(c);
            if (tmp.length() % 2 != 0) continue;
            int cur = Integer.parseInt(tmp.toString());
            if (cur > 23) {
                res.add("00");
            } else {
                res.add(tmp.toString());
            }
            tmp = new StringBuilder();
        }
        if (res.size() == 3) {
            return String.join((CharSequence)":", res);
        }
        if (res.size() == 2) {
            res.add("00");
            return String.join((CharSequence)":", res);
        }
        if (res.size() == 1) {
            return (String)res.get(0) + ":00:00";
        }
        return "00:00:00";
    }
}

