/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbcasia.dc.utils;

import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.internal.util.codec.Base64;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.CipherInfoUtil;
import kd.ebg.egf.common.utils.DesUtil;

public class RequestUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RequestUtil.class);

    public static DefaultIcbcClient createClient(String accNo) {
        DefaultIcbcClient client;
        IParameter parameter = RequestContextUtils.getParameter();
        String appId = parameter.getBankParameter("appId");
        String publicKey = CipherInfoUtil.getKey((byte[])RequestUtil.getCA("public_key"));
        String signType = parameter.getBankParameter("signType");
        if (signType.equals("CA")) {
            String caPublicStr;
            String caPrivateStr;
            logger.info("\u7b7e\u540d\u7c7b\u578b\u4e3aca:" + signType);
            String caPassword = parameter.getBankParameter("capassword");
            try {
                caPrivateStr = CipherInfoUtil.getKey((byte[])Base64.encodeBase64((byte[])RequestUtil.getCA("caprivatestr")));
                caPublicStr = CipherInfoUtil.getKey((byte[])Base64.encodeBase64((byte[])RequestUtil.getCA("capublicstr")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            client = new DefaultIcbcClient(appId, caPrivateStr, publicKey, caPublicStr, caPassword);
        } else {
            logger.info("\u7b7e\u540d\u7c7b\u578b\u4e3a:" + signType);
            client = new DefaultIcbcClient(appId, signType, CipherInfoUtil.getKey((byte[])RequestUtil.getCA("private_key")), publicKey);
        }
        return client;
    }

    public static byte[] getCA(String id) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(id, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u3001\u79d8\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u8bc1\u4e66\u4e0e\u79d8\u94a5\u3002", (String)"RequestUtil_1", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        return DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
    }
}

