/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jsb.cmp.service.payment.samebank;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Packer;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameBankQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final Logger logger = LoggerFactory.getLogger(SameBankQueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "03020104A0239";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4f01\u4e1a\u4ea4\u6613\u6d41\u6c34\u72b6\u6001\u3002", (String)"SameBankQueryPayImpl_0", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"SameBankQueryPayImpl_1", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]));
        }
        Element root = Packer.buildHead((String)"00003020104A0239", (String)Sequence.gen16Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"reqDate", (String)paymentInfos[0].getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"reqSerialNo", (String)paymentInfos[0].getBankBatchSeqId());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg((String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser((Element)root);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SameBankQueryPayImpl_2", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("body");
        String busiStat = body.getChildTextTrim("busiStat");
        String JnlStat = body.getChildTextTrim("jnlStat");
        String jnlMsg = body.getChildTextTrim("jnlMsg");
        if ("S".equals(JnlStat) && "S".equals(busiStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SameBankQueryPayImpl_3", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), (String)JnlStat, (String)jnlMsg);
        } else if ("F".equals(JnlStat) && "F".equals(busiStat) || "F".equals(JnlStat) && "C".equals(busiStat) || "N".equals(JnlStat) && "F".equals(busiStat) || "N".equals(JnlStat) && "C".equals(busiStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SameBankQueryPayImpl_4", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), (String)JnlStat, (String)jnlMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SameBankQueryPayImpl_5", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), (String)JnlStat, (String)jnlMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg((String)super.recv(inputStream));
    }
}

