/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.CommumicationHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public boolean isSupportPage(BankBalanceRequest request) {
        return true;
    }

    public String pack(BankBalanceRequest request) {
        BankHeader header = request.getHeader();
        BankAcnt acnt = header.getAcnt();
        String squence = Sequence.genSequence();
        String currentPage = this.getCurrentPage();
        LocalDate searchDate = request.getStartDate().plusDays(Long.parseLong(currentPage));
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"DATE", (String)LocalDateUtil.formatDate((LocalDate)searchDate));
        String packAll = Packer.packAllInOne((String)squence, (Element)reqParam);
        packAll = JDomUtils.xml2XmlWithOutIndentLineSeparator((String)packAll, (String)CommumicationHelper.getEncoding4Comm());
        String session = LoginAndOut.login4GetSession();
        return Packer.getCommonBizReqData((String)session, (String)"queryHistoryCurrentBalance1_1Op", (String)packAll);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        this.setLastPage(true);
        BalanceInfo info = new BalanceInfo();
        BankAcnt acnt = bankBalanceRequest.getHeader().getAcnt();
        BankResponse rsp = Parser.parseResponse(responseStr);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        try {
            Element root = JDomUtils.string2Root((String)responseStr, (String)"GBK");
            Element opRep = root.getChild("opRep");
            Element opResult = opRep.getChild("opResult");
            String acno = opResult.getChildTextTrim("ACNO");
            this.setBankAcnt(info, bankBalanceRequest.getBankAcntList(), acno);
            String avlb = opResult.getChildTextTrim("AVLB");
            this.setCurrentBalance(info, avlb);
            this.setAvailableBalance(info, avlb);
            String currentPage = this.getCurrentPage();
            LocalDate searchDate = bankBalanceRequest.getStartDate().plusDays(Long.parseLong(currentPage));
            String date = LocalDateUtil.formatDate((LocalDate)searchDate);
            info.setBalanceDateTime(LocalDateTime.parse(date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            String currency = opResult.getChildTextTrim("ZHLX");
            if (StringUtils.isNotEmpty((String)currency)) {
                info.setBankCurrency(currency);
            } else {
                info.setBankCurrency(acnt.getCurrency());
            }
            if (searchDate.isEqual(bankBalanceRequest.getEndDate())) {
                this.setLastPage(true);
            } else {
                this.setCurrentPage(Integer.parseInt(currentPage) + 1);
            }
        }
        catch (Exception e) {
            info.setError(e.getMessage());
        }
        balances.add(info);
        return new EBBankBalanceResponse(balances);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "queryHistoryCurrentBalance1_1Op";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HistoryBalanceImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]);
    }

    public int queryDays() {
        return 1;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
        if (CommonUtil.isCFCA().booleanValue()) {
            factory.setHttpHeader("Content-Type-CFCA", "123456");
        }
    }
}

