/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class NewDetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public String pack(BankDetailRequest request) {
        Element reqParam = new Element("ReqParam");
        BankAcnt acnt = request.getHeader().getAcnt();
        JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate()));
        JDomUtils.addChild((Element)reqParam, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate()));
        JDomUtils.addChild((Element)reqParam, (String)"QryTp", (String)"P(50)");
        int currentPage = Integer.parseInt(this.getCurrentPage()) + 1;
        JDomUtils.addChild((Element)reqParam, (String)"CrnPgNo", (String)(currentPage + ""));
        if (currentPage != 1) {
            JDomUtils.addChild((Element)reqParam, (String)"TotLineNum", (String)RequestContextUtils.getRunningParam((String)"TotLineNum"));
            JDomUtils.addChild((Element)reqParam, (String)"LclTotLineNum", (String)RequestContextUtils.getRunningParam((String)"LclTotLineNum"));
            JDomUtils.addChild((Element)reqParam, (String)"QrySrlNo", (String)RequestContextUtils.getRunningParam((String)"QrySrlNo"));
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"TotLineNum");
            JDomUtils.addChild((Element)reqParam, (String)"LclTotLineNum");
            JDomUtils.addChild((Element)reqParam, (String)"QrySrlNo");
        }
        String packAll = Packer.packAllInOne((String)Sequence.gen18Sequence(), (Element)reqParam);
        packAll = packAll.replaceAll("\r", "").replaceAll("\n", "");
        String session = LoginAndOut.login4GetSession();
        String opName = this.getBizCode();
        return Packer.getCommonBizReqData((String)session, (String)opName, (String)packAll);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        int total;
        BankResponse rsp = Parser.parseResponse(responseStr);
        String rspCode = rsp.getResponseCode();
        if (!"0".equals(rspCode)) {
            throw EBExceiptionUtil.serviceException((String)rsp.getResponseMessage());
        }
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GBK");
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String totLineNum = ParserUtils.checkUnNullableElementUnTrim((Element)opResult, (String)"TotLineNum");
        int cur = Integer.parseInt(this.getCurrentPage()) + 1;
        if (cur * 50 < (total = Integer.parseInt(totLineNum))) {
            this.setCurrentPage(cur);
            RequestContextUtils.setRunningParam((String)"TotLineNum", (String)totLineNum);
            String lclTotLineNum = ParserUtils.checkUnNullableElementUnTrim((Element)opResult, (String)"LclTotLineNum");
            RequestContextUtils.setRunningParam((String)"LclTotLineNum", (String)lclTotLineNum);
            String qrySrlNo = opResult.getChildTextTrim("QrySrlNo");
            RequestContextUtils.setRunningParam((String)"QrySrlNo", (String)qrySrlNo);
        } else {
            this.setLastPage(true);
        }
        Element opResultSet = opRep.getChild("opResultSet");
        List list = opResultSet.getChildren("opResult");
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            String CDFG = ParserUtils.getUnNullElementTextValue((Element)element, (String)"DbCrdtFlg", (String)ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u6807\u5fd7", (String)"TodayDetailImpl_5", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
            String FSJE = ParserUtils.getUnNullElementTextValue((Element)element, (String)"Amount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"TodayDetailImpl_6", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
            String PATI = element.getChildTextTrim("Summary");
            String transDate = element.getChildTextTrim("TransDate");
            String transTime1 = element.getChildTextTrim("TransTime");
            String DFZH = element.getChildTextTrim("OppAcctNo");
            String DFHM = element.getChildTextTrim("OppAcctNm");
            String YUER = element.getChildTextTrim("Balance");
            String YOTU = element.getChildTextTrim("FundUsage");
            String BEZH = element.getChildTextTrim("Remark");
            String Ccy = element.getChildTextTrim("Ccy");
            DetailInfo detail = new DetailInfo();
            detail.setAccName(acnt.getAccName());
            detail.setAccNo(acnt.getAccNo());
            detail.setOppAccName(DFHM);
            detail.setOppAccNo(DFZH);
            String DebitFlag = "D";
            String CreditFlag = "C";
            if (StringUtils.isEmpty((String)FSJE)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u91d1\u989d\u5b57\u6bb5", (String)"NewDetailImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
            }
            BigDecimal amt = new BigDecimal(FSJE);
            if (DebitFlag.equals(CDFG)) {
                detail.setDebitAmount(amt);
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else if (CreditFlag.equals(CDFG)) {
                detail.setCreditAmount(amt);
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u501f\u8d37\u65b9\u6807\u5fd7\u503c\u5f02\u5e38(\u975e%1$s/%2$s):%3$s\u3002", (String)"TodayDetailImpl_11", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), CreditFlag, DebitFlag, CDFG));
            }
            if (!StringUtils.isEmpty((String)YUER)) {
                detail.setBalance(new BigDecimal(YUER));
            }
            LocalDateTime transTime = null;
            try {
                transTime = LocalDateTime.parse(transDate + transTime1, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                detail.setTransDate(transTime.toLocalDate());
                detail.setTransTime(transTime);
            }
            catch (Exception ex) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u4e2d\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u7684\u65e5\u671f\u4e0d\u6b63\u786e\u3002", (String)"TodayDetailImpl_8", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (Throwable)ex);
            }
            String bankDetailSeqId = null;
            if (!StringUtils.isEmpty((String)BEZH) && BEZH.indexOf("@KD") != -1) {
                bankDetailSeqId = BEZH.substring(0, BEZH.indexOf("@KD"));
                if (bankDetailSeqId.length() > 13) {
                    bankDetailSeqId = bankDetailSeqId.substring(bankDetailSeqId.length() - 13);
                }
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
            } else if (!StringUtils.isEmpty((String)YOTU) && YOTU.indexOf("@KD") != -1) {
                bankDetailSeqId = YOTU.substring(0, YOTU.indexOf("@KD"));
                if (bankDetailSeqId.length() > 13) {
                    bankDetailSeqId = bankDetailSeqId.substring(bankDetailSeqId.length() - 13);
                }
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
            }
            if (!StringUtils.isEmpty((String)YOTU)) {
                detail.setExplanation(YOTU);
            } else {
                detail.setExplanation(PATI);
            }
            detail.setCurrency(Ccy);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("JYRQ_P", (Object)LocalDateUtil.formatDate((LocalDate)detail.getTransDate(), (String)"yyyyMMdd"));
            jsonObject.put("rCDFG", (Object)(DebitFlag.equals(CDFG) ? "D" : "C"));
            jsonObject.put("CDFG", (Object)(DebitFlag.equals(CDFG) ? "1" : "2"));
            if (!StringUtils.isEmpty((String)YUER)) {
                BigDecimal yue = new BigDecimal(YUER).setScale(2);
                jsonObject.put("YUER", (Object)yue.toPlainString());
            }
            BigDecimal fs = new BigDecimal(FSJE).setScale(2);
            jsonObject.put("FSJE", (Object)fs.toPlainString());
            jsonObject.put("DFZH", (Object)DFZH);
            jsonObject.put("T24F", (Object)element.getChildTextTrim("CoreTxnSrlNo"));
            jsonObject.put("serialNo", (Object)element.getChildTextTrim("CoreTxnSrlNo"));
            detail.setJsonMap(jsonObject.toJSONString());
            detail.setBankDetailNo(element.getChildTextTrim("CoreTxnSrlNo"));
            String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonObject.toJSONString());
            detail.setReceiptNo(receiptNo);
            details.add(detail);
        }
        EBBankDetailResponse response = new EBBankDetailResponse();
        response.setDetails(details);
        return response;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "MCAcctTxnRcrdPageQry1_1Op";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean isSupportPage() {
        return true;
    }

    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.isChooseNewDetail();
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
    }
}

