/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.login;

import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.ConfigurationUtil;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOutPacker;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOutParser;
import kd.ebg.aqap.banks.bosh.dc.service.sign.SignHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.BOSH_URLEncode;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.CommumicationHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;

public class LoginAndOut {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(LoginAndOut.class);

    public static String login4GetSession() {
        String bosh_urlencoded;
        String sequence = Sequence.gen18Sequence();
        String loginMsg = LoginAndOutPacker.packLoginMsg((String)sequence);
        String signedLoginMsg = SignHelper.sign(loginMsg);
        if (CommonUtil.isCFCA().booleanValue() && !"0".equalsIgnoreCase(bosh_urlencoded = ConfigurationUtil.getString((String)"BOSH_URLENCODED"))) {
            signedLoginMsg = signedLoginMsg.replace("+", "%2B").replace("/", "%2F").replace("=", "%3D").replace("\r", "").replace("\n", "");
        }
        String reqData = BOSH_URLEncode.encode((String)signedLoginMsg);
        StringBuilder buffer = new StringBuilder();
        buffer.append("opName").append("=").append("CebankUserLogon1_1Op").append("&").append("reqData").append("=").append(reqData);
        String recvMsg = LoginAndOut.sendAndRecvMsg4Login(buffer.toString());
        String session = LoginAndOutParser.parseLogonSessionID(recvMsg);
        recvMsg = recvMsg.substring(41);
        BankResponse rsp = Parser.parseResponse(recvMsg);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u767b\u5f55\u4ea4\u6613\u5931\u8d25\uff0c\u94f6\u884c\u54cd\u5e94:%1$s\uff0c%2$s\u3002", (String)"LoginAndOut_1", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendAndRecvMsg4Login(String msg) {
        try {
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/CM/APISessionReqServlet?" + msg);
            factory.setHttpHeader("User-Agent", "MSIE");
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream outputStream = conn.getOutputStream();){
                String string = CommumicationHelper.sendAndRecvMessage((IConnection)conn, (OutputStream)outputStream, (String)msg);
                return string;
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }
}

