/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.CommumicationHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "queryTransferResult1_2Op";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"OSNO", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        String packAll = Packer.packAllInOne((String)Sequence.gen16Sequence(), (Element)reqParam);
        packAll = JDomUtils.xml2XmlWithOutIndentLineSeparator((String)packAll, (String)CommumicationHelper.getEncoding4Comm());
        String session = LoginAndOut.login4GetSession();
        return Packer.getCommonBizReqData((String)session, (String)"queryTransferResult1_2Op", (String)packAll);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        logger.info("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)responseStr);
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponse(responseStr);
        if (!"0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u6b21\u540c\u6b65\u3002", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return EBGBusinessUtils.buildQueryPayResponse((List)paymentInfos);
        }
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String RECO = opResult.getChildTextTrim("RECO");
        if (!StringUtils.isEmpty((String)RECO)) {
            this.processWithRECO((PaymentInfo)paymentInfos.get(0), opResult);
        } else {
            this.processWithT24C((PaymentInfo)paymentInfos.get(0), opResult);
        }
        return EBGBusinessUtils.buildQueryPayResponse((List)paymentInfos);
    }

    public int getBatchSize() {
        return 1;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }

    private PaymentInfo processWithRECO(PaymentInfo paymentInfo, Element opResult) {
        String RECO = opResult.getChildTextTrim("RECO");
        String REMG = opResult.getChildTextTrim("REMG");
        if ("0000".equals(RECO)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)RECO, (String)REMG);
        } else if ("0001".equals(RECO) || "0002".equals(RECO) || "0003".equals(RECO) || "0005".equals(RECO)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)RECO, (String)REMG);
        } else if ("0004".equals(RECO) || "0006".equals(RECO)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)RECO, (String)REMG);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)RECO, (String)REMG);
        }
        return paymentInfo;
    }

    private PaymentInfo processWithT24C(PaymentInfo paymentInfo, Element opResult) {
        String T24C = opResult.getChildTextTrim("T24C");
        String T24M = opResult.getChildTextTrim("T24M");
        String CNAC = opResult.getChildTextTrim("CNAC");
        String CNAR = opResult.getChildTextTrim("CNAR");
        String RECO = opResult.getChildTextTrim("RECO");
        String REMG = opResult.getChildTextTrim("REMG");
        StringBuilder sb = new StringBuilder(T24M);
        sb.append(T24M).append(";");
        this.appendIfNotNull(sb, CNAC, "CNAC");
        this.appendIfNotNull(sb, CNAR, "CNAR");
        this.appendIfNotNull(sb, RECO, "RECO");
        this.appendIfNotNull(sb, REMG, "REMG");
        if ("000000".equals(T24C)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)T24C, (String)T24M);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)T24C, (String)sb.toString());
        }
        return paymentInfo;
    }

    private StringBuilder appendIfNotNull(StringBuilder buffer, String data, String tip) {
        if (!StringUtils.isEmpty((String)data)) {
            buffer.append(tip).append("=").append(data).append(";");
        }
        return buffer;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
        if (CommonUtil.isCFCA().booleanValue()) {
            factory.setHttpHeader("Content-Type-CFCA", "123456");
        }
    }
}

