/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment.salary;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.service.payment.salary.PayPacker;
import kd.ebg.aqap.banks.bosh.dc.service.payment.salary.QueryPaymentImpl;
import kd.ebg.aqap.banks.bosh.dc.service.proxy.FileUpload;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "APIUploadUNFileServlet";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u8d44\u63a5\u53e3", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        String charsetName = RequestContextUtils.getRequestContext().getCharsetName();
        List paymentInfos = request.getPaymentInfos();
        String fileContent = PayPacker.packPay((List)paymentInfos);
        String customerNo = RequestContextUtils.getBankParameterValue((String)"USER_ID");
        String bankBatchSeqId = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId();
        String fileName = customerNo + "_012_" + bankBatchSeqId + ".txt";
        String session = LoginAndOut.login4GetSession();
        StringBuilder localStringBuilder = new StringBuilder();
        localStringBuilder.append("http://").append(RequestContextUtils.getBankParameterValue((String)"ip")).append(":").append(RequestContextUtils.getBankParameterValue((String)"exchangePort")).append("/CM/APIUploadUNFileServlet?dse_sessionId=").append(session).append("&").append("serialNo").append("=").append(bankBatchSeqId);
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"URL", (String)localStringBuilder.toString());
        JDomUtils.addChild((Element)reqParam, (String)"fileContent", (String)fileContent);
        JDomUtils.addChild((Element)reqParam, (String)"fileName", (String)fileName);
        JDomUtils.addChild((Element)reqParam, (String)"bizType", (String)"uploadFile");
        JDomUtils.addChild((Element)reqParam, (String)"serialNo", (String)bankBatchSeqId);
        JDomUtils.addChild((Element)reqParam, (String)"verifyIp", (String)RequestContextUtils.getBankParameterValue((String)"ip"));
        JDomUtils.addChild((Element)reqParam, (String)"verifyPort", (String)RequestContextUtils.getBankParameterValue((String)"signPort"));
        return Packer.packAllInOne((String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID(), (Element)reqParam);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        FileUpload fileUpload = new FileUpload();
        fileUpload.setRequestPacketStr(this.pack(request));
        String res = fileUpload.doBiz();
        return this.parse(request, res);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        BankResponse rsp = Parser.parseResponse(responseStr);
        if (!"0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PayParser_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u94f6\u884c", (String)"PayParser_1", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (String)"", (String)"");
        }
        EBBankPayResponse response = new EBBankPayResponse();
        response.setPaymentInfos(paymentInfos);
        return response;
    }

    public int getBatchSize() {
        return 1000;
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
        if (CommonUtil.isCFCA().booleanValue()) {
            factory.setHttpHeader("Content-Type-CFCA", "123456");
        }
    }
}

