/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment.single.other;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.service.payment.single.QuerySinglePayImpl;
import kd.ebg.aqap.banks.bosh.dc.service.sign.SignHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.BOSH_URLEncode;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QuerySinglePayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"VIRACNO", (String)"");
        JDomUtils.addChild((Element)reqParam, (String)"OPAC", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"NAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"PBNO", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)reqParam, (String)"TRAM", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        if (BankBusinessConfig.isDescToUse()) {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)CommonUtil.getSubString(paymentInfo.getExplanation(), 20));
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)paymentInfo.getUseCn());
        }
        String exp = paymentInfo.getExplanation();
        if (exp.length() > 40) {
            exp = exp.substring(0, 35);
        }
        JDomUtils.addChild((Element)reqParam, (String)"REMK", (String)exp);
        String packAll = Packer.packAllInOne((String)paymentInfo.getBankBatchSeqID(), (Element)reqParam);
        packAll = packAll.replaceAll("\r", "").replaceAll("\n", "");
        String signedPayMsg = SignHelper.sign(packAll);
        String reqData = BOSH_URLEncode.encode((String)signedPayMsg);
        String session = LoginAndOut.login4GetSession();
        return Packer.getCommonBizReqData((String)session, (String)this.getBizCode(), (String)reqData);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List infos = bankPayRequest.getPaymentInfos();
        BankResponse rsp = Parser.parseResponse(responseStr);
        if ("0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        EBBankPayResponse response = new EBBankPayResponse();
        response.setPaymentInfos(infos);
        return response;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "transferCrossBankPreAuth1_1Op";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u4ed8\u6b3e", (String)"OtherBankPayImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
        if (CommonUtil.isCFCA().booleanValue()) {
            factory.setHttpHeader("Content-Type-CFCA", "123456");
        }
    }
}

