/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crbc.dc.service.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class CommonDetailParser {
    public static EBBankDetailResponse parseDetail(BankDetailRequest bankDetailRequest, List<Element> list) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(CommonDetailParser.class);
        ArrayList<DetailInfo> DetailList = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (Element detailElement : list) {
            DetailInfo detailInfo = new DetailInfo();
            try {
                String currency = detailElement.getChildText("CCY");
                String cdFlag = detailElement.getChildText("CR_DR_MAINT_IND");
                String tranAmt = detailElement.getChildText("TRAN_AMT");
                String tranTime = detailElement.getChildText("TRAN_TIME");
                String tranDate = detailElement.getChildText("TRAN_DATE");
                String actualBalAmt = detailElement.getChildText("ACTUAL_BAL_AMT");
                String tfrAcctName = detailElement.getChildText("TFR_ACCT_NAME");
                String tfrAcctNo = detailElement.getChildText("TFR_ACCT_NO");
                String tfrAcctBranch = detailElement.getChildText("TFR_ACCT_BRANCH");
                String seqNo = detailElement.getChildText("SEQ_NO");
                String explanation = detailElement.getChildText("TRAN_NOTE");
                String seqAccNo = detailElement.getChildText("SEQ_ACC_NO");
                detailInfo.setCurrency(currency);
                detailInfo.setTransDate(LocalDateUtil.parserDate((String)tranDate, (String)"yyyyMMdd"));
                if (StringUtils.isEmpty((String)tranTime)) {
                    tranTime = "000000";
                }
                if (tranTime.length() == 6) {
                    tranTime = tranDate + tranTime;
                }
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)tranTime));
                if (StringUtils.isEmpty((String)tranAmt)) {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailAmountEmptyErrorTips());
                }
                if ("C".equals(cdFlag)) {
                    detailInfo.setCreditAmount(BigDecimalHelper.str2BigDecimal((String)tranAmt));
                    detailInfo.setDebitAmount(BigDecimal.ZERO);
                } else if ("D".equals(cdFlag)) {
                    detailInfo.setCreditAmount(BigDecimal.ZERO);
                    detailInfo.setDebitAmount(BigDecimalHelper.str2BigDecimal((String)tranAmt));
                } else {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailCDFlagErrorTips((String)cdFlag));
                }
                detailInfo.setBalance(BigDecimalHelper.str2BigDecimal((String)actualBalAmt));
                detailInfo.setOppAccName(tfrAcctName);
                detailInfo.setOppAccNo(tfrAcctNo);
                detailInfo.setOppBankName(tfrAcctBranch);
                detailInfo.setBankDetailNo(seqAccNo);
                detailInfo.setExplanation(explanation);
                detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
                detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(detailElement);
                detailInfo.setJsonMap(jsonStr);
                String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate()), jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                continue;
            }
            DetailList.add(detailInfo);
        }
        return new EBBankDetailResponse(DetailList);
    }
}

