/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opb.util.security;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opb.util.Parser;
import kd.ebg.aqap.banks.gdb.opb.util.security.Hex;
import kd.ebg.aqap.banks.gdb.opb.util.security.RSAUtils;
import kd.ebg.aqap.banks.gdb.opb.util.security.SM2Util;
import kd.ebg.aqap.banks.gdb.opb.util.security.SM4Util;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SecurityUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SecurityUtil.class);

    public static String bytesToHexString(byte[] ba) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < ba.length; ++i) {
            s.append(String.format("%02X", ba[i]));
        }
        return s.toString();
    }

    public static String signPwd(String pwd) {
        String publicKey = SecurityUtil.getUserPublicKey();
        int length = pwd.length();
        if (length < 10) {
            pwd = "0" + length + pwd;
        } else {
            if (length >= 100) {
                return "888";
            }
            pwd = length + pwd;
        }
        try {
            return "====================" + SecurityUtil.bytesToHexString(SM2Util.encrypt((byte[])Hex.decode((String)publicKey), (byte[])pwd.getBytes()));
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u64cd\u4f5c\u5458\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25\u3002", (String)"SecurityUtil_0", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), (Throwable)ex);
        }
    }

    public static Map<String, String> buildSendParam(String originalMsg, boolean needSign, String encoding) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            String oriReqStr = originalMsg;
            logger.info("\u8bf7\u6c42\u62a5\u6587\u539f\u6587\uff1a\n" + oriReqStr);
            String entSignature = "";
            if (needSign) {
                // empty if block
            }
            byte[] signDigest = RSAUtils.sha1X16((String)(oriReqStr + entSignature), (String)encoding);
            String signature = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])RSAUtils.signBySoft((PrivateKey)SecurityUtil.getUserPrivateKey(), (byte[])signDigest)));
            logger.info("\u91d1\u8776\u7b7e\u540d\u7ed3\u679c\uff1a\n" + signature);
            byte[] sm4keyByte = SM4Util.generateKey((int)128);
            String sm4Key = Hex.encode((byte[])sm4keyByte);
            String msg = Hex.encode((byte[])SM4Util.encryptECB((byte[])oriReqStr.getBytes(), (byte[])sm4keyByte));
            logger.info("\u8bf7\u6c42\u62a5\u6587\u52a0\u5bc6\u7ed3\u679c\uff1a\n" + msg);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher.init(1, SecurityUtil.getPublicKey());
            String etKey = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])cipher.doFinal(sm4keyByte)), encoding);
            result.put("signature", signature);
            result.put("msg", msg);
            result.put("etKey", etKey);
        }
        catch (Exception e) {
            logger.info("\u52a0\u5bc6\u6216\u7b7e\u540d\u5931\u8d25\uff1a", (Object)e.getMessage());
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u52a0\u5bc6\u6216\u7b7e\u540d\u5931\u8d25:", (String)"SecurityUtil_1", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), (Throwable)e);
        }
        return result;
    }

    public static String getReceMsg(String resp, String encryptKey, String encoding) {
        try {
            if (resp.contains("sysRetCode")) {
                JSONObject jsonObject = JSONObject.parseObject((String)resp);
                Parser.parseHeader((JSONObject)jsonObject, (String)"");
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher.init(2, SecurityUtil.getUserPrivateKey());
            byte[] sm4keyByte = cipher.doFinal(org.apache.commons.codec.binary.Base64.decodeBase64((byte[])encryptKey.getBytes(encoding)));
            String respStr = new String(SM4Util.decryptECB((byte[])Hex.decode((String)resp), (byte[])sm4keyByte));
            logger.info("\u54cd\u5e94\u62a5\u6587\uff1a\n" + respStr);
            return respStr;
        }
        catch (Exception e) {
            logger.info("\u89e3\u5bc6\u5931\u8d25\uff1a", (Object)e.getMessage());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u5931\u8d25:%s\u3002", (String)"SecurityUtil_9", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    private static String getUserPublicKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("public_key", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u884c\u516c\u94a5\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u94f6\u884c\u516c\u94a5\u3002", (String)"SecurityUtil_3", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = SecurityUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return SecurityUtil.getKey(fileContent);
    }

    private static PrivateKey getUserPrivateKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("private_key", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u3002", (String)"SecurityUtil_4", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = SecurityUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        InputStream keyStream = null;
        try {
            PrivateKey privateKey;
            KeyStore ks = KeyStore.getInstance("JKS");
            keyStream = new ByteArrayInputStream(fileContent);
            ks.load(keyStream, certInfo.getCertPassword().toCharArray());
            PrivateKey privateKey2 = privateKey = (PrivateKey)ks.getKey(SecurityUtil.getAlias(ks.aliases()), certInfo.getCertPassword().toCharArray());
            return privateKey2;
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u662f\u5426\u6b63\u786e\u3002", (String)"SecurityUtil_5", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
        }
        finally {
            try {
                if (keyStream != null) {
                    keyStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static PublicKey getPublicKey() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_public_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u884c\u516c\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u94f6\u884c\u516c\u94a5\u8bc1\u4e66\u3002", (String)"SecurityUtil_6", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
        }
        return SecurityUtil.getPublicKey(certInfo.getFileContent(), certInfo.getCustomID(), certInfo.getCertID());
    }

    private static X509Certificate getX509Certificate(InputStream inputStream) throws CertificateException {
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return cert;
        }
        catch (CertificateException e) {
            logger.error(e.toString(), (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey getPublicKey(String data, String customID, String certID) {
        try {
            CipherInfo cipherInfo = SecurityUtil.getCipherInfo(data);
            byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)customID, (int)cipherInfo.getCipherVersion(), (String)certID);
            try (ByteArrayInputStream keyStream = null;){
                keyStream = new ByteArrayInputStream(fileContent);
                X509Certificate cert = SecurityUtil.getX509Certificate(keyStream);
                PublicKey publicKey = cert.getPublicKey();
                return publicKey;
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6publicKey\u5931\u8d25%s\u3002", (String)"SecurityUtil_10", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    public static String getAlias(Enumeration<String> aliases) {
        if (aliases.hasMoreElements()) {
            return aliases.nextElement();
        }
        return null;
    }
}

