/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbc.dc;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ocbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ocbc.dc.BankDetailSeqIdCreator;
import kd.ebg.aqap.banks.ocbc.dc.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.ocbc.dc.services.detail.DetailImpl;
import kd.ebg.aqap.banks.ocbc.dc.services.detail.HisDetailImpl;
import kd.ebg.aqap.banks.ocbc.dc.services.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.ocbc.dc.services.payment.company.CompanyPaymentQueryImpl;
import kd.ebg.aqap.banks.ocbc.dc.services.payment.company.PaymentImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class OcbcDcMetaDataImpl
extends FBEMetaDataTemplate
implements BankMetaDataCollector {
    private static final String BANK_VERSION_ID = "OCBC_DC";
    public static final String YHIDKHID = "YHIDKHID";
    public static final String KHBH = "KHBH";
    public static final String YHID = "YHID";
    public static final String p12Cert = "p12_cert";
    public static final String certPin = "certPin";

    public void baseConfigInit() {
        this.setExchangeProtocol("HTTP");
        this.setTimeOut(3);
        this.setCharSet("UTF-8");
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u534e\u4fa8\u6c38\u4ea8\u94f6\u884c", (String)"OcbcDcMetaDataImpl_0", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]));
        this.setBankVersionID(BANK_VERSION_ID);
        this.setBankShortName("OCBC");
        this.setBankVersionName(ResManager.loadKDString((String)"\u534e\u4fa8\u94f6\u884c\uff08\u4e2d\u56fd\u5927\u9646\uff09\u76f4\u8054\u7248", (String)"OcbcDcMetaDataImpl_1", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u534e\u4fa8\u6c38\u4ea8\u94f6\u884c", (String)"OcbcDcMetaDataImpl_0", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)YHIDKHID, (MultiLangEnumBridge)new MultiLangEnumBridge("\u6e20\u9053\u5ba2\u6237\u7aef\u7528\u6237ID\u3002", "OcbcDcMetaDataImpl_5", "ebg-aqap-banks-ocbc-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63d0\u4f9b", "OcbcDcMetaDataImpl_6", "ebg-aqap-banks-ocbc-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)KHBH, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4f01\u4e1a\u5ba2\u6237\u53f7", "OcbcDcMetaDataImpl_7", "ebg-aqap-banks-ocbc-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63d0\u4f9b", "OcbcDcMetaDataImpl_6", "ebg-aqap-banks-ocbc-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)YHID, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237\u767b\u5f55ID", "OcbcDcMetaDataImpl_8", "ebg-aqap-banks-ocbc-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63d0\u4f9b", "OcbcDcMetaDataImpl_6", "ebg-aqap-banks-ocbc-dc"), (String)"", (boolean)false, (boolean)false)});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{BalanceImpl.class, DetailImpl.class, HisDetailImpl.class, PaymentImpl.class, PretreatmentImpl.class, CompanyPaymentQueryImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList((Object[])new Class[]{BankDetailSeqIdCreator.class});
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public boolean isDetailSupportMultiCurrency() {
        return true;
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("JYRQ", DetailUniqueTypeEnum.STRING.getType());
        result.put("JYSJ", DetailUniqueTypeEnum.STRING.getType());
        result.put("JYPZ", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

