/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ljb.dc.service.payment;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ljb.dc.service.utils.CommonPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject bankRequest = CommonPacker.createRequest(Sequence.gen16Sequence(), this.getBizCode());
        String reqDate = LocalDateUtil.formatDate((LocalDate)paymentInfo.getSubmitSuccessTime().toLocalDate());
        bankRequest.put("reqDate", (Object)reqDate);
        bankRequest.put("reqSerialNo", (Object)paymentInfo.getBankDetailSeqId());
        return bankRequest.toJSONString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject response = JSONObject.parseObject((String)res);
        String tfrStat = response.getString("tfrStat");
        String handMsg = response.getString("handMsg");
        if ("S".equals(tfrStat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)tfrStat, (String)handMsg);
        } else if ("F".equals(tfrStat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)tfrStat, (String)handMsg);
        } else if ("P".equals(tfrStat) || "L".equals(tfrStat) || "R".equals(tfrStat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)tfrStat, (String)handMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)tfrStat, (String)handMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "02620100A0113";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26\u67e5\u8be2", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-ljb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/json");
        super.configFactory(factory);
    }
}

