/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hfb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hfb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hfb.dc.util.HFB_Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailParser {
    private static final Logger logger = LoggerFactory.getLogger(DetailParser.class);

    public static List<DetailInfo> parseDetail(BankDetailRequest request, String responseStr) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = HFB_Parser.parserHead((Element)root);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s,%2$s", (String)"DetailParser_2", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String acno = opResult.getChildTextTrim("ACNO");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(64);
        BankAcnt acnt = request.getAcnt();
        Element lists = opRep.getChild("opResultSet");
        String count = opResult.getChildText("TTTS");
        Integer TotleCount = Integer.parseInt(count);
        if (TotleCount == 0) {
            return detailList;
        }
        if (!request.getAcnt().getAccNo().equals(acno)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u539f\u56e0:\u8bf7\u6c42\u8d26\u53f7\u4e0e\u94f6\u884c\u54cd\u5e94\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4.", (String)"DetailParser_1", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]));
        }
        List list = lists.getChildren("opResult");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Element row : list) {
            DetailInfo detail = new DetailInfo();
            String currencyCode = row.getChildTextTrim("BIZH");
            String payeeAcNo = row.getChildTextTrim("RANO");
            String payeeAcName = row.getChildTextTrim("RANM");
            String rcbn = row.getChildTextTrim("RCBN");
            detail.setCurrency(currencyCode);
            detail.setOppAccNo(payeeAcNo);
            detail.setOppAccName(payeeAcName);
            detail.setOppBankName(rcbn);
            detail.setAccName(acnt.getAccName());
            detail.setAccNo(acnt.getAccNo());
            String transferDate = row.getChildTextTrim("HPDT");
            String transTime = row.getChildTextTrim("HPTM");
            detail.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            if (StringUtils.isNotEmpty((String)transTime)) {
                detail.setTransTime(LocalDateTime.parse(transferDate + transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            } else {
                detail.setTransTime(LocalDateTime.parse(transferDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            String payAmount = row.getChildTextTrim("FASE");
            String recAmount = row.getChildTextTrim("FASE");
            BigDecimal payAmountD = new BigDecimal(payAmount);
            BigDecimal recAmountD = new BigDecimal(recAmount);
            String CDFlag = row.getChildTextTrim("JDFX");
            if (CDFlag.equalsIgnoreCase("D")) {
                detail.setDebitAmount(payAmountD);
                detail.setCreditAmount(new BigDecimal(0));
            } else if (CDFlag.equalsIgnoreCase("C")) {
                detail.setDebitAmount(new BigDecimal(0));
                detail.setCreditAmount(recAmountD);
            } else {
                detail.setDebitAmount(payAmountD);
                detail.setCreditAmount(recAmountD);
            }
            String AcctBal = row.getChildTextTrim("THYE");
            if (StringUtils.isNotEmpty((String)AcctBal)) {
                BigDecimal balance = new BigDecimal(AcctBal);
                detail.setBalance(balance);
            }
            String summary = "";
            if (row.getChildTextTrim("ZHYO") != null) {
                summary = row.getChildTextTrim("ZHYO");
            }
            detail.setExplanation(summary);
            String bezu = row.getChildTextTrim("BEZU");
            if (!StringUtils.isEmpty((String)bezu)) {
                int index = bezu.indexOf("_KD_");
                if (index != -1) {
                    String bankDetailSeqId = BizNoUtil.getId((String)bezu);
                    String remark = BizNoUtil.getMsg((String)bezu);
                    detail.setKdFlag(bankDetailSeqId);
                    detail.setPayBankDetailSeqID(bankDetailSeqId);
                    if (StringUtils.isEmpty((String)detail.getExplanation())) {
                        detail.setExplanation(remark);
                    }
                    DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                } else if (StringUtils.isEmpty((String)detail.getExplanation())) {
                    detail.setExplanation(bezu);
                }
            }
            String sequ = row.getChildTextTrim("SEQU");
            detail.setThirdBankName(sequ);
            detail.setBankDetailNo(sequ);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            if (BankBusinessConfig.isMasterPush((String)request.getAcnt().getBankLoginId(), (String)RequestContext.get().getTenantId())) {
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("Amount", (Object)payAmount);
                jsonObject.put("oppAccNo", (Object)payeeAcNo);
                if (Objects.equals(CDFlag, "C")) {
                    jsonObject.put("cdFlag", (Object)"2");
                }
                if (Objects.equals(CDFlag, "D")) {
                    jsonObject.put("cdFlag", (Object)"1");
                }
                jsonStr = jsonObject.toJSONString();
            }
            detail.setJsonMap(jsonStr);
            String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(request.getAcnt().getAccNo(), transDateStr, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int countI = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, countI);
                receiptNo = receiptNo + "-" + String.format("%04d", countI);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detailList.add(detail);
        }
        return detailList;
    }
}

