/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hfb.dc.util;

import java.io.File;
import java.io.IOException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class FileUtils {
    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtils.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw EBExceiptionUtil.serviceException((String)message);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw EBExceiptionUtil.serviceException((String)message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw EBExceiptionUtil.serviceException((String)message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                FileUtils.delete(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean isDeleted;
            boolean filePresent = file.exists();
            if (filePresent && !(isDeleted = file.delete())) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }
}

