/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.alipay.cmp.service.detail;

import com.alibaba.fastjson.JSON;
import com.alipay.api.domain.AccountLogItemResult;
import com.alipay.api.request.AlipayDataBillAccountlogQueryRequest;
import com.alipay.api.response.AlipayDataBillAccountlogQueryResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.alipay.cmp.AlipayBusinessConfig;
import kd.ebg.aqap.banks.alipay.cmp.utils.AlipayRequestUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;

public class AccountDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AccountDetailImpl.class);
    private int size = 1000;

    public EBBankDetailResponse doBizWithPage(BankDetailRequest request) {
        ArrayList detailList = new ArrayList(16);
        this.setCurrentPage("1");
        this.setLastPage(false);
        try {
            do {
                EBBankDetailResponse response = this.getDetailResponse(request);
                detailList.addAll(response.getDetails());
            } while (!this.isLastPage());
            return new EBBankDetailResponse(detailList);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankDetailResponse getDetailResponse(BankDetailRequest request) {
        AlipayDataBillAccountlogQueryRequest bankRequest = new AlipayDataBillAccountlogQueryRequest();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("start_time", request.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00");
        LocalDate dayAfter = LocalDateUtil.getDayAfter((LocalDate)request.getEndDate(), (int)1);
        params.put("end_time", dayAfter.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00");
        params.put("page_no", this.getCurrentPage());
        params.put("page_size", this.size + "");
        bankRequest.setBizContent(JSON.toJSONString(params));
        this.logger.info("\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8bf7\u6c42\u62a5\u6587:{}", (Object)bankRequest.getBizContent());
        try {
            AlipayDataBillAccountlogQueryResponse response = (AlipayDataBillAccountlogQueryResponse)AlipayRequestUtil.execute(bankRequest, request.getAcnt().getAccNo());
            this.logger.info("\u652f\u4ed8\u5b9d\u660e\u7ec6\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JsonUtil.toJsonLine((Object)response));
            if (!response.isSuccess()) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8c03\u7528\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25\uff0c\u652f\u4ed8\u5b9d\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"DetailImpl_18", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), response.getMsg(), response.getSubCode(), response.getSubMsg()));
            }
            int totalSize = Integer.parseInt(response.getTotalSize());
            int cur = Integer.parseInt(this.getCurrentPage());
            if (cur + this.size - 1 < totalSize) {
                this.setLastPage(false);
                this.setCurrentPage(cur + this.size);
            } else {
                this.setLastPage(true);
            }
            List detailList = response.getDetailList();
            if (detailList == null) {
                ArrayList detail = new ArrayList(1);
                EBBankDetailResponse rsp = new EBBankDetailResponse();
                rsp.setDetails(detail);
                return rsp;
            }
            List<DetailInfo> detail = this.getDetail(detailList, request.getBankCurrency(), request.getAcnt());
            EBBankDetailResponse rsp = new EBBankDetailResponse();
            rsp.setDetails(detail);
            return rsp;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8c03\u7528\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u4e0b\u8f7d\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public List<DetailInfo> getDetail(List<AccountLogItemResult> detailList, String currency, BankAcnt acnt) {
        ArrayList<DetailInfo> temp = new ArrayList<DetailInfo>(16);
        boolean serialChoose = AlipayBusinessConfig.isNewDetailSerialNoConfig();
        for (AccountLogItemResult info : detailList) {
            DetailInfo detail = new DetailInfo();
            String transDt = info.getTransDt();
            String transAmount = info.getTransAmount();
            String otherAccount = info.getOtherAccount();
            if (StringUtils.isNotEmpty((String)otherAccount) && otherAccount.contains("(")) {
                String oppoAccNo = otherAccount.substring(otherAccount.indexOf("(") + 1, otherAccount.indexOf(")"));
                String oppoName = otherAccount.substring(0, otherAccount.indexOf("("));
                detail.setOppAccNo(oppoAccNo);
                detail.setOppAccName(oppoName);
            }
            String direction = info.getDirection();
            String bizDesc = info.getBizDesc();
            String transMemo = info.getTransMemo();
            String serial = serialChoose ? info.getMerchantOrderNo() : info.getAlipayOrderNo();
            LocalDateTime time = LocalDateTime.parse(transDt, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            detail.setTransTime(time);
            detail.setTransDate(time.toLocalDate());
            BigDecimal amount = new BigDecimal(transAmount);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"transferDate", (Object)LocalDateUtil.formatDate((LocalDate)detail.getTransDate(), (String)"yyyy-MM-dd"));
            jsonObject.put((Object)"transferFlowNo", (Object)serial);
            if (amount.compareTo(BigDecimal.ZERO) < 0) {
                detail.setDebitAmount(amount.abs());
                jsonObject.put((Object)"debitAmount", (Object)transAmount);
                jsonObject.put((Object)"creditAmount", (Object)"0.00");
                detail.setCreditAmount(BigDecimal.ZERO);
            } else {
                detail.setCreditAmount(amount);
                jsonObject.put((Object)"debitAmount", (Object)"0.00");
                jsonObject.put((Object)"creditAmount", (Object)transAmount);
                detail.setDebitAmount(BigDecimal.ZERO);
            }
            jsonObject.put((Object)"bizDesc", (Object)bizDesc);
            jsonObject.put((Object)"transMemo", (Object)transMemo);
            detail.setJsonMap(jsonObject.toString());
            detail.setBankDetailNo(serial.trim());
            detail.setExplanation(transMemo);
            detail.setReversed1(bizDesc);
            detail.setCurrency(currency);
            detail.setAccNo(acnt.getAccNo());
            detail.setBankName(acnt.getBankName());
            detail.setAccName(acnt.getAccName());
            temp.add(detail);
        }
        return temp;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "accountlog.query";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankDetailRequest request) {
        return !AlipayBusinessConfig.isUseUrl4Detail();
    }

    public boolean isSupportPage() {
        return true;
    }
}

