/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.alipay.cmp.utils;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.banks.alipay.cmp.AlipayBusinessConfig;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.crypto.DigestUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AlipayRequestUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(AlipayRequestUtil.class);

    public static AlipayClient createClient(String accNo) {
        AlipayRequestUtil.checkParamsNotNull(false, accNo);
        String appId = AlipayBusinessConfig.getAppId(accNo);
        String privateKey = AlipayRequestUtil.getRealCertContent("alipay_app_private_key", EBContext.getContext().getCustomID(), accNo);
        String publicKey = AlipayRequestUtil.getRealCertContent("alipay_public_key", EBContext.getContext().getCustomID(), accNo);
        String url = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol") + "://" + RequestContextUtils.getBankParameterValue((String)"alipay_ip") + RequestContextUtils.getBankParameterValue((String)"address");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(url, appId, privateKey, "json", "GBK", publicKey, AlipayBusinessConfig.getEncryptedType(accNo));
        return alipayClient;
    }

    public static AlipayClient createCertClient(String accNo) {
        DefaultAlipayClient alipayClient;
        AlipayRequestUtil.checkParamsNotNull(true, accNo);
        String customID = EBContext.getContext().getCustomID();
        String appId = AlipayBusinessConfig.getAppId(accNo);
        String url = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol") + "://" + RequestContextUtils.getBankParameterValue((String)"alipay_ip") + RequestContextUtils.getBankParameterValue((String)"address");
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        certAlipayRequest.setServerUrl(url);
        certAlipayRequest.setAppId(appId);
        certAlipayRequest.setPrivateKey(AlipayRequestUtil.getRealCertContent("alipay_app_private_key", customID, accNo));
        certAlipayRequest.setFormat("json");
        certAlipayRequest.setCharset("GBK");
        certAlipayRequest.setSignType(AlipayBusinessConfig.getEncryptedType(accNo));
        certAlipayRequest.setCertContent(AlipayRequestUtil.getRealCertContent("alipay_app_public_cert", customID, accNo));
        certAlipayRequest.setAlipayPublicCertContent(AlipayRequestUtil.getRealCertContent("alipay_public_cert", customID, accNo));
        certAlipayRequest.setRootCertContent(AlipayRequestUtil.getRealCertContent("alipay_root_cert", customID, accNo));
        try {
            alipayClient = new DefaultAlipayClient(certAlipayRequest);
        }
        catch (AlipayApiException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9e\u4f8b\u5316\u8bc1\u4e66\u7c7b\u578b\u652f\u4ed8\u5b9dsdk\u5ba2\u6237\u7aef\u5f02\u5e38\u3002", (String)"AlipayRequestUtil_0", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        return alipayClient;
    }

    public static final String prepareUrlParameters(String service, Map<String, String> params) {
        String pid = RequestContextUtils.getBankParameterValue((String)"alipay_cmp_appId");
        if (StringUtils.isEmpty((String)pid)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5546\u6237\u7b7e\u7ea6\u5e10\u53f7PID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5728\u524d\u7f6e\u673a\u7ba1\u7406\u9875\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"AlipayRequestUtil_1", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
        }
        params.put("partner", pid);
        params.put("service", service);
        params.put("_input_charset", "GBK");
        params.put("sign_type", "MD5");
        params.put("sign", AlipayRequestUtil.buildRequestMysign(AlipayRequestUtil.paraFilter(params)));
        return AlipayRequestUtil.createLinkString(params);
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>(sArray.size());
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (Map.Entry<String, String> entry : sArray.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isEmpty((String)value) || "sign".equalsIgnoreCase(key) || "sign_type".equalsIgnoreCase(key)) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                buffer.append(key);
                buffer.append('=');
                buffer.append(value);
                continue;
            }
            buffer.append(key);
            buffer.append('=');
            buffer.append(value);
            buffer.append('&');
        }
        prestr = buffer.toString();
        return prestr;
    }

    public static String buildRequestMysign(Map<String, String> sPara) {
        String prestr = AlipayRequestUtil.createLinkString(sPara);
        String md5Key = RequestContextUtils.getBankParameterValue((String)"alipay_md5Key");
        return DigestUtil.md5Hex((String)(prestr + md5Key), (String)"GBK");
    }

    public static AlipayResponse execute(AlipayRequest<?> request, String accNo) throws AlipayApiException {
        AlipayResponse response;
        if ("cert".equalsIgnoreCase(AlipayBusinessConfig.getSignType(accNo))) {
            AlipayClient alipayClient = AlipayRequestUtil.createCertClient(accNo);
            response = alipayClient.certificateExecute(request);
        } else {
            AlipayClient alipayClient = AlipayRequestUtil.createClient(accNo);
            response = alipayClient.execute(request);
        }
        return response;
    }

    public static void checkParamsNotNull(boolean isCertFlag, String accNo) {
        String publicKey;
        String appId = AlipayBusinessConfig.getAppId(accNo);
        if (StringUtils.isEmpty((String)appId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AlipayRequestUtil_2", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
        }
        String privateKey = AlipayRequestUtil.getRealCertContent("alipay_app_private_key", EBContext.getContext().getCustomID(), accNo);
        if (StringUtils.isEmpty((String)privateKey)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e94\u7528\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u8d26\u6237\u9875\u9762\u9644\u52a0\u5c5e\u6027\u91cc\u4e0a\u4f20\u3002", (String)"AlipayRequestUtil_3", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
        }
        String signType = AlipayBusinessConfig.getSignType(accNo);
        if (!"cert".equalsIgnoreCase(signType) && StringUtils.isEmpty((String)(publicKey = AlipayRequestUtil.getRealCertContent("alipay_public_key", EBContext.getContext().getCustomID(), accNo)))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u8d26\u6237\u9875\u9762\u9644\u52a0\u5c5e\u6027\u91cc\u4e0a\u4f20\u3002", (String)"AlipayRequestUtil_4", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
        }
        if (isCertFlag) {
            String appCertPath = AlipayRequestUtil.getRealCertContent("alipay_app_public_cert", EBContext.getContext().getCustomID(), accNo);
            if (StringUtils.isEmpty((String)appCertPath)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5e94\u7528\u516c\u94a5\u8bc1\u4e66\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u8d26\u6237\u9875\u9762\u9644\u52a0\u5c5e\u6027\u91cc\u4e0a\u4f20\u3002", (String)"AlipayRequestUtil_5", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
            }
            String alipayCertPath = AlipayRequestUtil.getRealCertContent("alipay_public_cert", EBContext.getContext().getCustomID(), accNo);
            if (StringUtils.isEmpty((String)alipayCertPath)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u8d26\u6237\u9875\u9762\u9644\u52a0\u5c5e\u6027\u91cc\u4e0a\u4f20\u3002", (String)"AlipayRequestUtil_6", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
            }
            String alipayRootCertPath = AlipayRequestUtil.getRealCertContent("alipay_root_cert", EBContext.getContext().getCustomID(), accNo);
            if (StringUtils.isEmpty((String)alipayRootCertPath)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u6839\u8bc1\u4e66\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AlipayRequestUtil_7", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
            }
        }
    }

    public static String getRealCertContent(String name, String customId, String acctNo) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findAccCertByBankLoginIDAndBankConfigIDAndCustomID(name, RequestContextUtils.getRequestContext().getBankLoginID(), customId, acctNo);
        if (certInfo != null && StringUtils.isNotEmpty((String)certInfo.getFileContent())) {
            byte[] certBytes;
            AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
            CipherInfo cipherInfo = security.getCipherInfo(certInfo.getFileContent());
            int version = cipherInfo.getCipherVersion();
            String id = "";
            if (version == 0) {
                certBytes = Base64.getDecoder().decode(cipherInfo.getCipherData());
                id = AlipayRequestUtil.getID(name);
            } else {
                certBytes = org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData());
            }
            byte[] plainData = DesUtil.decryptProxyCert((byte[])certBytes, (String)customId, (int)version, (String)id);
            return StringUtils.byteToString((byte[])plainData);
        }
        return "";
    }

    private static String getID(String name) {
        String id = "";
        String bankLoginID = EBContext.getContext().getBankLoginID();
        QFilter filter = QFilter.of((String)"bank_config_id=? and bank_login_id=?", (Object[])new Object[]{name, bankLoginID});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_bd_cert", (String)"id", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            id = dynamicObject.getString("id");
        }
        return id;
    }
}

